/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CustomFieldsDefinition {
    static ESLLogger logger = ESLLogger.getLogger(CustomFieldsDefinition.class);
    private final List<String> customFields = new ArrayList<String>();

    public CustomFieldsDefinition(File customFieldDefinitionFile) throws InitializationException {
        try {
            this.readCustomFields(new BufferedReader(new FileReader(customFieldDefinitionFile)));
        }
        catch (FileNotFoundException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IOException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (RuntimeException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public List<String> getCustomFields() {
        return Collections.unmodifiableList(this.customFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readCustomFields(BufferedReader reader) throws IOException {
        try {
            String line = reader.readLine();
            while (line != null) {
                this.readLine(line);
                line = reader.readLine();
            }
        }
        finally {
            StreamUtils.close((Reader)reader);
        }
    }

    private void readLine(String line) {
        if (!(line = line.trim()).isEmpty() && !line.startsWith("#")) {
            this.customFields.add(line);
        }
    }
}

