/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.persistence;

import at.mrdevelopment.esl.persistence.DatasetField;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;

public class CustomDatasetField
extends DatasetField {
    private final String key;

    public CustomDatasetField(String key, DatasetField datasetField) {
        super(datasetField);
        this.key = key;
    }

    @Override
    public String getName() {
        return StringUtils.capitalize((String)this.key);
    }

    @Override
    public boolean canBeNull() {
        return true;
    }

    @Override
    public Object getValue(Object record) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        return this.getGetterMethod().invoke(record, this.key);
    }

    @Override
    public void setValue(Object record, Object value) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.getSetterMethod().invoke(record, this.key, value);
    }

    @Override
    protected Method getSetterMethod() {
        try {
            return this.getGetterMethod().getDeclaringClass().getMethod("set" + this.getInternalName(), String.class, this.getGetterMethod().getReturnType());
        }
        catch (NoSuchMethodException ignore) {
            return null;
        }
    }
}

