/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.msp;

import at.mrdevelopment.esl.core.ServiceStatus;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.esl.xml.ServiceStatusXMLSerializer;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.http.XMLContentProducer;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.w3c.dom.Document;

public class MSPStatusXMLUploader {
    static ESLLogger logger = ESLLogger.getLogger(MSPStatusXMLUploader.class);
    private static final String MSP_STYLE_SHEET = "/webroot/xsl/msp.xsl";
    private Transformer transformer;
    private ServiceStatusXMLSerializer serializer = new ServiceStatusXMLSerializer();

    public MSPStatusXMLUploader() throws InitializationException {
        try {
            this.initializeTransformer();
        }
        catch (TransformerConfigurationException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    private void initializeTransformer() throws TransformerConfigurationException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        InputStream xslStream = MSPStatusXMLUploader.class.getResourceAsStream(MSP_STYLE_SHEET);
        StreamSource xslSource = new StreamSource(xslStream);
        this.transformer = transformerFactory.newTemplates(xslSource).newTransformer();
    }

    public void uploadToMSP(MSPConfiguration mspConfiguration, ServiceStatus serviceStatus) {
        new Thread(new MSPUpload(mspConfiguration, serviceStatus)).start();
    }

    private class MSPUpload
    implements Runnable {
        private MSPConfiguration mspConfiguration;
        private ServiceStatus serviceStatus;

        public MSPUpload(MSPConfiguration mspConfiguration, ServiceStatus serviceStatus) {
            this.mspConfiguration = mspConfiguration;
            this.serviceStatus = serviceStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.info("Uploading MSP discovery information to %s", new Object[]{this.mspConfiguration.getHost()});
            Document serviceStatusDocument = MSPStatusXMLUploader.this.serializer.toXML(this.serviceStatus);
            String uuid = this.serviceStatus.getPropertyValue("uuid");
            if (uuid == null) {
                logger.warn("MSP discovery upload failed (Could not read UUID of device)");
                return;
            }
            XMLContentProducer contentProducer = new XMLContentProducer(serviceStatusDocument, MSPStatusXMLUploader.this.transformer, MSPStatusXMLUploader.MSP_STYLE_SHEET);
            String filenameId = UUID.randomUUID().toString().substring(0, 4);
            String filename = uuid + "_discovery_" + filenameId + ".xml";
            OutputStream outputStream = null;
            String host = this.mspConfiguration.getHost();
            int port = this.mspConfiguration.getPort();
            String username = this.mspConfiguration.getUsername();
            String password = this.mspConfiguration.getPassword();
            String path = this.mspConfiguration.getPath();
            FTPClient ftpClient = this.connect(host, port, username, password);
            if (ftpClient == null) {
                logger.warn("MSP discovery upload failed (Could not connect to MSP relay server)");
                return;
            }
            try {
                if (!ftpClient.login(username, password)) {
                    logger.warn("MSP discovery upload failed (Could not login to MSP relay server)");
                    return;
                }
                outputStream = ftpClient.storeFileStream(path + "/" + filename);
                if (outputStream != null) {
                    contentProducer.writeTo(outputStream);
                    outputStream.close();
                    boolean success = ftpClient.completePendingCommand();
                    int replyCode = ftpClient.getReplyCode();
                    if (success && FTPReply.isPositiveCompletion((int)replyCode)) {
                        logger.info("MSP discovery upload finished with reply code %d", new Object[]{replyCode});
                    } else {
                        logger.warn("MSP discovery upload failed with reply code %d", new Object[]{replyCode});
                    }
                } else {
                    logger.warn("MSP discovery upload failed (Could not open stream)");
                }
                StreamUtils.close((OutputStream)outputStream);
                this.disconnect(ftpClient);
            }
            catch (Exception exc) {
                logger.warn("MSP discovery upload failed with error '%s'", new Object[]{exc.getMessage()});
                logger.logExceptionIfDebugEnabled((Throwable)exc);
            }
            finally {
                StreamUtils.close(outputStream);
                this.disconnect(ftpClient);
            }
        }

        private FTPClient connect(String host, int port, String username, String password) {
            FTPClient ftpClient = null;
            try {
                ftpClient = new FTPClient();
                ftpClient.connect(host, port);
                return ftpClient;
            }
            catch (Exception exc) {
                this.disconnect(ftpClient);
                return null;
            }
        }

        private void disconnect(FTPClient ftpClient) {
            if (ftpClient != null && ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (Exception exc) {
                    logger.logException((Throwable)exc);
                }
            }
        }
    }
}

