/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licencing;

import at.mrdevelopment.esl.type.Licence;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LicenceXMLSerializer
implements XMLSerializer<Licence> {
    private static final String XSD = "licence.xsd";
    private XMLToolkit xmlToolkit = new XMLToolkit("licence.xsd");

    public Document toXML(Licence licence) {
        Document document = this.xmlToolkit.newDocument();
        Element licenceKey = document.createElement("licenceKey");
        licenceKey.setTextContent(licence.getLicenceKey());
        Element commentKey = document.createElement("comment");
        commentKey.setTextContent(licence.getComment());
        Element element = document.createElement("labelLicence");
        element.appendChild(licenceKey);
        element.appendChild(commentKey);
        document.appendChild(element);
        return document;
    }

    public Licence parseXML(InputStream xmlInputStream) throws SerializeException {
        Element root = this.xmlToolkit.getDocumentRootFromInputStream(xmlInputStream);
        return this.parseLicenceFromXML(root);
    }

    private Licence parseLicenceFromXML(Element element) throws SerializeException {
        NodeList licenceKeyList = element.getElementsByTagName("licenceKey");
        NodeList commentList = element.getElementsByTagName("comment");
        String licenceKey = licenceKeyList.item(0).getTextContent().trim();
        String comment = commentList.item(0).getTextContent().trim();
        return new Licence(comment, licenceKey);
    }
}

