/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licencing;

import at.mrdevelopment.esl.licencing.DecryptInputStream;
import at.mrdevelopment.esl.type.LicenceContent;
import at.mrdevelopment.esl.type.LicencedFeature;
import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.Range;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.openssl.PEMReader;

public class LicenceImport {
    public static final String PUBLIC_KEY = "/licence/licence.public";
    private final PublicKey key = this.readPublicKey();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenceContent readFromLicenceKey(String labelString) throws SerializeException {
        LicenceContent licenceContent;
        ReaderInputStream inputStream = null;
        try {
            inputStream = new ReaderInputStream((Reader)new BufferedReader(new StringReader(labelString)));
            licenceContent = this.readFromStream((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.close(inputStream);
            throw throwable;
        }
        StreamUtils.close((InputStream)inputStream);
        return licenceContent;
    }

    private LicenceContent readFromStream(InputStream licenceInputStream) throws SerializeException {
        try {
            DecryptInputStream inputStream = new DecryptInputStream(licenceInputStream, this.key);
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            return this.readLicenceContent(reader);
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    protected LicenceContent readLicenceContent(BufferedReader reader) throws SerializeException {
        try {
            ArrayList<Range<Address>> labelRanges = new ArrayList<Range<Address>>();
            HashSet<LicencedFeature> features = new HashSet<LicencedFeature>();
            String line = reader.readLine();
            while (line != null) {
                String[] tokens = StringUtils.split((String)line, (String)":");
                if (tokens != null && tokens.length == 2) {
                    String lineIdentifier = tokens[0];
                    String lineContent = tokens[1];
                    if (lineIdentifier.equals("l")) {
                        labelRanges.add(this.readRangeLine(lineContent));
                    } else if (lineIdentifier.equals("f")) {
                        LicencedFeature feature = this.readFeature(lineContent);
                        features.add(feature);
                    }
                }
                line = reader.readLine();
            }
            return new LicenceContent(labelRanges, features);
        }
        catch (IOException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private Range<Address> readRangeLine(String content) throws SerializeException {
        String[] tokens = StringUtils.split((String)content, (String)";");
        try {
            if (tokens == null) {
                throw new SerializeException("Invalid label file format", new Object[0]);
            }
            if (tokens.length == 1) {
                Address address = Address.fromString(tokens[0]);
                return new Range((Comparable)address, (Comparable)address);
            }
            if (tokens.length == 2) {
                Address from = Address.fromString(tokens[0]);
                Address to = Address.fromString(tokens[1]);
                return new Range((Comparable)from, (Comparable)to);
            }
            throw new SerializeException("Invalid label file format", new Object[0]);
        }
        catch (NumberFormatException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private LicencedFeature readFeature(String content) throws SerializeException {
        String[] tokens = StringUtils.split((String)content, (String)"=");
        try {
            if (tokens == null) {
                throw new SerializeException("Invalid label file format", new Object[0]);
            }
            if (tokens.length == 1) {
                String key = tokens[0];
                return new LicencedFeature(key);
            }
            if (tokens.length == 2) {
                String key = tokens[0];
                String value = tokens[1];
                return new LicencedFeature(key, value);
            }
            throw new SerializeException("Invalid label file format", new Object[0]);
        }
        catch (NumberFormatException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey readPublicKey() throws InitializationException {
        RSAPublicKey rSAPublicKey;
        InputStream inputStream = LicenceImport.class.getResourceAsStream(PUBLIC_KEY);
        PEMReader keyReader = new PEMReader((Reader)new InputStreamReader(inputStream));
        try {
            rSAPublicKey = (RSAPublicKey)keyReader.readObject();
        }
        catch (Throwable throwable) {
            try {
                keyReader.close();
                throw throwable;
            }
            catch (Exception exc) {
                throw new InitializationException((Throwable)exc, "Failed to load licence decryption key", new Object[0]);
            }
        }
        keyReader.close();
        return rSAPublicKey;
    }
}

