/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licencing;

import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.Range;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang.StringUtils;

public class LabelSetImport {
    static ESLLogger logger = ESLLogger.getLogger(LabelSetImport.class);

    public Set<Address> readLabelsFromStream(InputStream labelInputStream) throws SerializeException {
        return this.readLabels(new BufferedReader(new InputStreamReader(labelInputStream)));
    }

    public Set<Address> readLabelsFromString(String labelString) throws SerializeException {
        return this.readLabelsFromStream((InputStream)new ReaderInputStream((Reader)new StringReader(labelString)));
    }

    public Set<Address> readLabelsFromFile(File labelFile) throws SerializeException {
        Set<Address> set;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(labelFile);
            set = this.readLabelsFromStream(inputStream);
        }
        catch (FileNotFoundException exc) {
            try {
                throw new SerializeException((Throwable)exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
        }
        StreamUtils.close((InputStream)inputStream);
        return set;
    }

    protected Set<Address> readLabels(BufferedReader reader) throws SerializeException {
        TreeSet<Address> labelList = new TreeSet<Address>();
        try {
            String line = reader.readLine();
            while (line != null) {
                this.readLine(line, labelList);
                line = reader.readLine();
            }
            return labelList;
        }
        catch (IOException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private void readLine(String line, Set<Address> labelList) throws SerializeException {
        block6: {
            String[] tokens = StringUtils.split((String)line, (String)";");
            try {
                if (tokens == null) {
                    throw new SerializeException("Invalid label file format", new Object[0]);
                }
                if (tokens.length == 1) {
                    labelList.add(Address.fromString(tokens[0]));
                    break block6;
                }
                if (tokens.length == 2) {
                    Address from = Address.fromString(tokens[0]);
                    Address to = Address.fromString(tokens[1]);
                    Range addressRange = new Range((Comparable)from, (Comparable)to);
                    for (Address address : addressRange) {
                        labelList.add(address);
                    }
                    break block6;
                }
                throw new SerializeException("Invalid label file format", new Object[0]);
            }
            catch (NumberFormatException exc) {
                throw new SerializeException((Throwable)exc);
            }
        }
    }
}

