/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licencing;

import at.mrdevelopment.esl.wireless.Address;
import at.mrdevelopment.toolkit.Range;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang.StringUtils;

public class LabelRangeImport {
    static ESLLogger logger = ESLLogger.getLogger(LabelRangeImport.class);

    public List<Range<Address>> readLabelRangesFromStream(InputStream inputStream) throws SerializeException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        return this.readLabelRanges(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Range<Address>> readLabelRangesFromString(String labelString) throws SerializeException {
        List<Range<Address>> list;
        ReaderInputStream inputStream = null;
        try {
            inputStream = new ReaderInputStream((Reader)new BufferedReader(new StringReader(labelString)));
            list = this.readLabelRangesFromStream((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            StreamUtils.close(inputStream);
            throw throwable;
        }
        StreamUtils.close((InputStream)inputStream);
        return list;
    }

    public List<Range<Address>> readLabelRangesFromFile(File file) throws SerializeException {
        List<Range<Address>> list;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            list = this.readLabelRangesFromStream(inputStream);
        }
        catch (IOException exc) {
            try {
                throw new SerializeException((Throwable)exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(inputStream);
                throw throwable;
            }
        }
        StreamUtils.close((InputStream)inputStream);
        return list;
    }

    protected List<Range<Address>> readLabelRanges(BufferedReader reader) throws SerializeException {
        try {
            ArrayList<Range<Address>> labelRanges = new ArrayList<Range<Address>>();
            String line = reader.readLine();
            while (line != null) {
                labelRanges.add(this.readLine(line));
                line = reader.readLine();
            }
            return labelRanges;
        }
        catch (IOException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }

    private Range<Address> readLine(String line) throws SerializeException {
        String[] tokens = StringUtils.split((String)line.trim(), (String)";");
        try {
            if (tokens == null) {
                throw new SerializeException("Invalid label file format", new Object[0]);
            }
            if (tokens.length == 1) {
                Address address = Address.fromString(tokens[0]);
                return new Range((Comparable)address, (Comparable)address);
            }
            if (tokens.length == 2) {
                Address from = Address.fromString(tokens[0]);
                Address to = Address.fromString(tokens[1]);
                return new Range((Comparable)from, (Comparable)to);
            }
            throw new SerializeException("Invalid label file format", new Object[0]);
        }
        catch (NumberFormatException exc) {
            throw new SerializeException((Throwable)exc);
        }
    }
}

