/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.licencing;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.codec.binary.Base64InputStream;

public class DecryptInputStream
extends InputStream {
    private final InputStream inputStream;

    public DecryptInputStream(InputStream inputStream, Key rsaKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IOException {
        Base64InputStream base64stream = new Base64InputStream(inputStream);
        Key sessionKey = this.readSessionKey((InputStream)base64stream, rsaKey);
        Cipher cipher = Cipher.getInstance("AES");
        cipher.init(2, sessionKey);
        this.inputStream = new CipherInputStream((InputStream)base64stream, cipher);
    }

    private Key readSessionKey(InputStream inputStream, Key rsaKey) throws IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        DataInputStream dataStream = new DataInputStream(inputStream);
        int length = dataStream.readInt();
        byte[] wrappedKey = new byte[length];
        dataStream.read(wrappedKey, 0, length);
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(4, rsaKey);
        return cipher.unwrap(wrappedKey, "AES", 3);
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

