/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.validator;

import at.mrdevelopment.esl.gui.validator.FormValidator;
import java.util.ArrayList;
import java.util.List;

public abstract class TextValidator<T>
implements FormValidator<T> {
    private List<String> errors = new ArrayList<String>();
    private T value;
    private boolean allowEmpty;

    public TextValidator(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public void validate() {
        this.clearErrors();
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        this.value = value;
    }

    protected boolean isAllowEmpty() {
        return this.allowEmpty;
    }

    protected void addError(String message) {
        this.errors.add(message);
    }

    @Override
    public void clearErrors() {
        this.errors.clear();
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    public void printErrors() {
        if (this.errors.size() > 0) {
            for (String error : this.errors) {
                System.out.println(error);
            }
        }
    }
}

