/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.validator;

import at.mrdevelopment.esl.gui.validator.TextValidator;

public class LongRangeValidator
extends TextValidator<String> {
    private final long from;
    private final long to;

    public LongRangeValidator(long from, long to, boolean allowEmpty) {
        super(allowEmpty);
        this.from = from;
        this.to = to;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getValue() == null || ((String)this.getValue()).isEmpty()) {
            if (!this.isAllowEmpty()) {
                this.addError("Must not be empty");
            }
            return;
        }
        Long longValue = null;
        try {
            longValue = Long.parseLong((String)this.getValue());
        }
        catch (NumberFormatException exc) {
            this.addError("Not a valid number");
            return;
        }
        if (longValue < this.from) {
            this.addError(String.format("Value is too small (must be >=%d)", this.from));
        } else if (longValue > this.to) {
            this.addError(String.format("Value is too large (must be <%d", this.to));
        }
    }
}

