/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.validator;

import at.mrdevelopment.esl.gui.validator.TextValidator;

public class HostnameValidator
extends TextValidator<String> {
    private static final String ONE_ALPHA = "(.)*((\\p{Alpha})|[-]|[_])(.)*";
    private static final String HOST_IDENTIFIER = "((\\p{Alnum})([_]|[-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})";
    private static final String HOSTNAME_RULE = "(((\\p{Alnum})([_]|[-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum}))((\\.)(((\\p{Alnum})([_]|[-]|(\\p{Alnum}))*(\\p{Alnum}))|(\\p{Alnum})))*";

    public HostnameValidator(boolean allowEmpty) {
        super(allowEmpty);
    }

    @Override
    public void validate() {
        String[] splittedHostname;
        super.validate();
        if (this.getValue() == null || ((String)this.getValue()).isEmpty()) {
            if (!this.isAllowEmpty()) {
                this.addError("Must not be empty");
            }
            return;
        }
        for (String hostnamePart : splittedHostname = ((String)this.getValue()).split("\\.")) {
            if (hostnamePart.length() <= 63) continue;
            this.addError("Not a valid hostname");
            return;
        }
        if (this.getValue() == null || ((String)this.getValue()).length() > 255) {
            this.addError("Not a valid hostname");
        }
        if (!((String)this.getValue()).matches(HOSTNAME_RULE) || !((String)this.getValue()).matches(ONE_ALPHA)) {
            this.addError("Not a valid hostname");
        }
    }
}

