/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.userinfo;

import at.mrdevelopment.esl.gui.ESLDialog;
import at.mrdevelopment.esl.gui.userinfo.ErrorMessage;
import at.mrdevelopment.toolkit.ExceptionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.joda.time.DateTime;

public class ExceptionMessage
extends ErrorMessage {
    private final Throwable exception;

    public ExceptionMessage(Throwable exception) {
        super(exception.getMessage() != null ? exception.getMessage() : exception.getClass().getSimpleName(), new Object[0]);
        this.exception = exception;
    }

    public ExceptionMessage(String message, Throwable exception) {
        super(exception.getMessage() != null ? message + ": " + exception.getMessage() : message + "(" + exception.getClass().getSimpleName() + ")", new Object[0]);
        this.exception = exception;
    }

    @Override
    public void execute() {
        String title = this.exception.getClass().getSimpleName() + ": " + this.exception.getMessage();
        ESLDialog frame = new ESLDialog(null, title, true);
        frame.setLayout(new BorderLayout());
        frame.setMinimumSize(new Dimension(200, 200));
        JTextArea textArea = new JTextArea(20, 100);
        textArea.setText(this.getMessage());
        textArea.setFont(new Font("Courier New", 0, 12));
        textArea.setEditable(false);
        textArea.setCaretPosition(0);
        JScrollPane scrollPane = new JScrollPane(textArea, 20, 30);
        frame.add((Component)scrollPane, "Center");
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    private String getMessage() {
        StringBuilder message = new StringBuilder();
        message.append(String.format("Message: %s\n", ExceptionUtils.getRootCause((Throwable)this.exception).getMessage()));
        message.append(String.format("Time: %s\n", new DateTime().toString()));
        message.append(String.format("Exception: %s\n", this.exception.getClass().getName()));
        for (StackTraceElement element : ExceptionUtils.getRootCause((Throwable)this.exception).getStackTrace()) {
            message.append("\t");
            message.append(element.toString());
            message.append("\n");
        }
        Throwable cause = this.exception.getCause();
        while (cause != null) {
            message.append(String.format("Caused by: %s\n", cause.getClass().getName()));
            cause = cause.getCause();
            for (StackTraceElement element : ExceptionUtils.getRootCause((Throwable)this.exception).getStackTrace()) {
                message.append("\t");
                message.append(element.toString());
                message.append("\n");
            }
        }
        return message.toString();
    }
}

