/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.gui.editor.AbstractFormEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public abstract class TextEditor<T>
extends AbstractFormEditor<T> {
    private JTextField editorComponent;

    public TextEditor() {
        this(30);
    }

    public TextEditor(int length) {
        this(new JTextField("", length));
    }

    public TextEditor(JTextField textField) {
        this.editorComponent = textField;
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent event) {
                TextEditor.this.contentChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                TextEditor.this.contentChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                TextEditor.this.contentChanged();
            }
        });
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editorComponent;
    }

    @Override
    public void setValue(Object value) {
        this.setEditorValue(value);
    }

    @Override
    public abstract T getValue();

    public void clear() {
        this.setEditorText(null);
        this.clearErrors();
    }

    protected void setEditorValue(T value) {
        this.setEditorText((String)value);
    }

    protected void setEditorText(String text) {
        this.editorComponent.setText(text);
    }

    protected String getEditorText() {
        return this.editorComponent.getText();
    }
}

