/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.gui.editor.TextEditor;

public class LongEditor
extends TextEditor<Long> {
    private Long longValue;

    @Override
    public void setValue(Object value) {
        if (value != null) {
            this.setEditorText(Long.toString((Long)value));
        }
    }

    @Override
    public Long getValue() {
        return this.longValue;
    }

    @Override
    public void validate() {
        super.validate();
        String value = this.getEditorText();
        if (!this.canBeNull() && value.isEmpty()) {
            this.addError("Field is empty");
        } else if (value.isEmpty()) {
            this.longValue = null;
        } else {
            try {
                this.longValue = Long.parseLong(value);
            }
            catch (NumberFormatException exc) {
                this.addError("Not a valid long value");
            }
        }
    }
}

