/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui.editor;

import at.mrdevelopment.esl.gui.editor.FormEditor;
import at.mrdevelopment.esl.gui.editor.FormEditorEventListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractFormEditor<T>
implements FormEditor<T> {
    protected static final Color ERROR_COLOR = new Color(255, 159, 159);
    protected static final Color NO_ERROR_COLOR_ENABLED = UIManager.getColor("TextField.background");
    protected static final Color NO_ERROR_COLOR_DISABLED = UIManager.getColor("TextField.disabledBackground");
    private final Set<FormEditorEventListener> listeners = new HashSet<FormEditorEventListener>();
    private final List<String> errors = new ArrayList<String>();
    private boolean canBeNull;

    @Override
    public void setCanBeNull(boolean canBeNull) {
        this.canBeNull = canBeNull;
    }

    @Override
    public void validate() {
        this.clearErrors();
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public void clearErrors() {
        this.errors.clear();
        JComponent editorComponent = this.getEditorComponent();
        editorComponent.setBackground(editorComponent.isEnabled() ? NO_ERROR_COLOR_ENABLED : NO_ERROR_COLOR_DISABLED);
        editorComponent.setToolTipText(null);
    }

    public void addError(String message) {
        this.errors.add(message);
        JComponent editorComponent = this.getEditorComponent();
        editorComponent.setBackground(ERROR_COLOR);
        editorComponent.setToolTipText(StringUtils.join(this.errors, (String)", "));
    }

    public void registerEventListener(FormEditorEventListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterEventListener(FormEditorEventListener listener) {
        this.listeners.remove(listener);
    }

    protected void contentChanged() {
        this.validate();
        if (this.hasErrors()) {
            this.notifyContentInvalid();
        } else {
            this.notifyContentValid();
        }
    }

    protected void notifyContentValid() {
        for (FormEditorEventListener listener : this.listeners) {
            listener.contentValid();
        }
    }

    protected void notifyContentInvalid() {
        for (FormEditorEventListener listener : this.listeners) {
            listener.contentInvalid();
        }
    }

    protected boolean canBeNull() {
        return this.canBeNull;
    }
}

