/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.gui.SpringUtilities;
import java.awt.Container;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SpringLayout;

public class TaskDetailsComponent
extends JComponent {
    private final JComboBox taskPriorities;
    private final JCheckBox replaceWaitingTasks;
    private final JComboBox pages;
    private final JCheckBox preload;
    private final JComboBox rotation;

    public TaskDetailsComponent(boolean showReplaceTasks) {
        this.setLayout(new SpringLayout());
        this.taskPriorities = new JComboBox();
        this.pages = new JComboBox();
        this.preload = new JCheckBox();
        this.replaceWaitingTasks = new JCheckBox();
        this.rotation = new JComboBox<Integer>(new Integer[]{0, 90, 180, 270});
        this.rotation.setSelectedIndex(0);
        this.rotation.setEditable(false);
        for (TaskPriority taskPriority : TaskPriority.values()) {
            this.taskPriorities.addItem(taskPriority);
        }
        this.taskPriorities.setSelectedItem((Object)TaskPriority.DEFAULT);
        for (Enum enum_ : Page.values()) {
            if (!((Page)enum_).isValid()) continue;
            this.pages.addItem(enum_);
        }
        this.add(new JLabel("Priority:", 11));
        this.add(this.taskPriorities);
        this.add(new JLabel("Page:", 11));
        this.add(this.pages);
        this.add(new JLabel("Preload image:", 11));
        this.add(this.preload);
        this.add(new JLabel("Rotation:", 11));
        this.add(this.rotation);
        if (showReplaceTasks) {
            this.add(new JLabel("Replace tasks:", 11));
            this.add(this.replaceWaitingTasks);
        }
        SpringUtilities.makeCompactGrid((Container)this, (int)(showReplaceTasks ? 5 : 4), (int)2, (int)8, (int)2, (int)4, (int)4);
    }

    public TaskPriority getTaskPriority() {
        return (TaskPriority)((Object)this.taskPriorities.getSelectedItem());
    }

    public boolean isReplaceWaitingTasks() {
        return this.replaceWaitingTasks.isSelected();
    }

    public Page getPage() {
        return (Page)((Object)this.pages.getSelectedItem());
    }

    public boolean isPreload() {
        return this.preload.isSelected();
    }

    public boolean isRotated() {
        Object selectedItem = this.rotation.getSelectedItem();
        return selectedItem != null && (Integer)selectedItem != 0;
    }

    public int getRotation() {
        Object selectedItem = this.rotation.getSelectedItem();
        return selectedItem != null ? (Integer)selectedItem : 0;
    }
}

