/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.core.ServiceStatusProvider;
import at.mrdevelopment.esl.gui.ESLDialog;
import at.mrdevelopment.esl.gui.ServiceStatusTableModel;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class ServiceStatusDialog {
    public ServiceStatusDialog(final ServiceStatusProvider serviceStatusProvider, JFrame parentFrame) {
        final ESLDialog dialog = new ESLDialog(parentFrame, "Service Status", true);
        dialog.setLayout(new BorderLayout());
        dialog.setDefaultCloseOperation(2);
        ActionListener closeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispose();
            }
        };
        final ServiceStatusTableModel model = new ServiceStatusTableModel(serviceStatusProvider.getServiceStatus());
        JTable table = new JTable(model);
        table.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 116) {
                    model.update(serviceStatusProvider.getServiceStatus());
                }
            }
        });
        JButton okButton = new JButton("OK");
        okButton.setFocusable(false);
        okButton.addActionListener(closeListener);
        GUIUtils.addEscapeListener((JDialog)dialog, (ActionListener)closeListener);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(okButton);
        dialog.add((Component)new JScrollPane(table), "Center");
        dialog.add((Component)buttonPanel, "South");
        dialog.getRootPane().setDefaultButton(okButton);
        dialog.setMinimumSize(new Dimension(100, 100));
        dialog.setPreferredSize(new Dimension(400, 500));
        dialog.pack();
        dialog.setLocationRelativeTo(parentFrame);
        dialog.setVisible(true);
    }
}

