/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.gui.ImagePreview;
import at.mrdevelopment.esl.gui.TaskDetailsComponent;
import at.mrdevelopment.esl.updatetask.TaskPriority;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.filechooser.FileNameExtensionFilter;

public class LabelImageFileChooser
extends JFileChooser {
    private final TaskDetailsComponent taskDetails = new TaskDetailsComponent(false);
    private final ImagePreview imagePreview = new ImagePreview(180, 120);

    public LabelImageFileChooser(String imageDirectory) {
        super(imageDirectory);
        this.setFileFilter(new FileNameExtensionFilter("Bitmaps", "bmp", "png"));
        this.addPropertyChangeListener(this.imagePreview);
        this.setAccessory(this.createAccessory());
    }

    private JComponent createAccessory() {
        JPanel previewComponent = new JPanel(new BorderLayout());
        previewComponent.setBorder(GUIUtils.createBorder((String)"Image preview", (int)0, (int)7, (int)0, (int)0));
        previewComponent.add((Component)this.imagePreview, "Center");
        JPanel detailsComponent = new JPanel(new BorderLayout());
        detailsComponent.setBorder(GUIUtils.createBorder((String)"Task details", (int)3, (int)7, (int)0, (int)0));
        detailsComponent.add((Component)this.taskDetails, "Center");
        JPanel accessory = new JPanel(new BorderLayout());
        accessory.add((Component)previewComponent, "Center");
        accessory.add((Component)detailsComponent, "Last");
        return accessory;
    }

    public TaskPriority getTaskPriority() {
        return this.taskDetails.getTaskPriority();
    }

    public boolean isReplaceWaitingTasks() {
        return this.taskDetails.isReplaceWaitingTasks();
    }

    public Page getPage() {
        return this.taskDetails.getPage();
    }

    public boolean isPreload() {
        return this.taskDetails.isPreload();
    }

    public boolean isRotated() {
        return this.taskDetails.isRotated();
    }

    public int getRotation() {
        return this.taskDetails.getRotation();
    }
}

