/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.type.LabelErrors;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class LabelErrorsTableCellRenderer
extends DefaultTableCellRenderer {
    private static final Color ERROR_BACKGROUND_COLOR = new Color(255, 91, 91);
    private static final Color ERROR_TEXT_COLOR = Color.WHITE;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        if (value != null) {
            LabelErrors labelErrors = (LabelErrors)value;
            this.setText(this.getErrorText(labelErrors));
            this.setHorizontalAlignment(0);
            this.setToolTipText(this.getErrorDescription(labelErrors));
            if (!isSelected) {
                if (labelErrors.hasErrors()) {
                    this.setForeground(ERROR_TEXT_COLOR);
                    this.setBackground(ERROR_BACKGROUND_COLOR);
                } else {
                    this.setForeground(Color.BLACK);
                    this.setBackground(Color.WHITE);
                }
            }
        } else {
            if (!isSelected) {
                this.setBackground(Color.WHITE);
            }
            this.setToolTipText(null);
        }
        return this;
    }

    private String getErrorText(LabelErrors labelErrors) {
        if (labelErrors.hasErrors()) {
            return String.format("%03d", labelErrors.getErrorCode());
        }
        return "-";
    }

    private String getErrorDescription(LabelErrors labelErrors) {
        StringBuilder builder = new StringBuilder();
        builder.append("<html>");
        if (labelErrors.hasErrors()) {
            builder.append(String.format("Error code %d with following errors:", labelErrors.getErrorCode()));
            if (labelErrors.hasDisplayUpdateAtUnspecifiedTemperature()) {
                builder.append("<br>Display was updated at temperature out of specified range");
            }
            if (labelErrors.hasDisplayUpdateErrorDetected()) {
                builder.append("<br>Display failed during update");
            }
            if (labelErrors.hasFlashIntegrityErrors()) {
                builder.append("<br>Flash integrity errors");
            }
            if (labelErrors.hasHighTransmissionFailedRate()) {
                builder.append("<br>High transmission fail rate");
            }
            if (labelErrors.hasTotalNumberOfTransmissionsExceeded()) {
                builder.append("<br>Total number of specified transmissions exceeded");
            }
            if (labelErrors.hasTotalNumberOfUpdatesExceeded()) {
                builder.append("<br>Total number of specified display updates exceeded");
            }
            if (labelErrors.hasUnexpectedResets()) {
                builder.append("<br>Unexpected resets");
            }
            if (labelErrors.hasOtherError()) {
                builder.append("<br>Other hardware related errors");
            }
        } else {
            builder.append("No errors");
        }
        builder.append("</html>");
        return builder.toString();
    }
}

