/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class ImagePreview
extends JComponent
implements PropertyChangeListener {
    private ImageIcon image = null;
    private ImageIcon thumbnail = null;
    private File file = null;

    public ImagePreview(int width, int height) {
        this.setPreferredSize(new Dimension(width, height));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                if (ImagePreview.this.isShowing()) {
                    ImagePreview.this.loadThumbnail();
                    ImagePreview.this.repaint();
                }
            }
        });
    }

    private void loadImage() {
        if (this.file == null) {
            this.image = null;
            return;
        }
        try {
            this.image = new ImageIcon(ImageIO.read(this.file));
        }
        catch (IOException ignore) {
            this.image = null;
        }
    }

    private void loadThumbnail() {
        if (this.image == null) {
            this.thumbnail = null;
            return;
        }
        double aspectRatio = (double)this.image.getIconWidth() / (double)this.image.getIconHeight();
        if (this.image.getIconWidth() > this.getWidth()) {
            int height = Math.min(this.getHeight(), (int)Math.floor((double)this.getWidth() / aspectRatio));
            int width = (int)Math.floor((double)height * aspectRatio);
            this.thumbnail = new ImageIcon(this.image.getImage().getScaledInstance(width, height, 4));
        } else if (this.image.getIconHeight() > this.getHeight()) {
            int width = Math.min(this.getWidth(), (int)Math.floor((double)this.getHeight() * aspectRatio));
            int height = (int)Math.floor((double)width / aspectRatio);
            this.thumbnail = new ImageIcon(this.image.getImage().getScaledInstance(width, height, 4));
        } else {
            this.thumbnail = this.image;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        boolean update = false;
        String property = event.getPropertyName();
        if ("directoryChanged".equals(property)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(property)) {
            this.file = (File)event.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.loadThumbnail();
                this.repaint();
            }
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.thumbnail != null) {
            int x = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int y = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            this.thumbnail.paintIcon(this, graphics, x, y);
        }
    }
}

