/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.gui.ESLFrame;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import at.mrdevelopment.toolkit.gui.MouseEventAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.lang.StringUtils;

public class ApplicationStarter {
    private final Map<String, Class<?>> applications;
    private JFrame frame;
    private JList applicationBox;
    private JTextArea parameterTextArea;

    public ApplicationStarter(Map<String, Class<?>> applications, String[] args) {
        this.applications = applications;
        if (args == null || args.length < 1) {
            GUIUtils.setSystemLookAndFeel();
            this.showFrame();
        } else {
            String[] arguments = new String[]{};
            String application = args[0];
            if (args.length > 1) {
                arguments = new String[args.length - 1];
                for (int i = 1; i < args.length; ++i) {
                    arguments[i - 1] = args[i];
                }
            }
            try {
                this.startApplication(application, arguments);
            }
            catch (InitializationException exc) {
                exc.printStackTrace();
                System.exit(1);
            }
        }
    }

    private void startApplication(String application, String[] arguments) throws InitializationException {
        try {
            Class<?> applicationClass = null;
            if (this.applications.containsKey(application)) {
                applicationClass = this.applications.get(application);
            } else {
                applicationClass = Class.forName(application);
                if (!this.applications.containsValue(applicationClass)) {
                    throw new InitializationException("No application known with the name %s", new Object[]{application});
                }
            }
            Method mainMethod = applicationClass.getMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{arguments});
        }
        catch (ClassNotFoundException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (SecurityException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (NoSuchMethodException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IllegalArgumentException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (IllegalAccessException exc) {
            throw new InitializationException((Throwable)exc);
        }
        catch (InvocationTargetException exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    private void showFrame() {
        this.frame = new ESLFrame();
        this.frame.setTitle("Support Application Starter");
        this.frame.setLayout(new BorderLayout());
        Object[] applicationNames = this.applications.keySet().toArray(new String[this.applications.size()]);
        Arrays.sort(applicationNames);
        this.applicationBox = new JList<Object>(applicationNames);
        this.applicationBox.setVisibleRowCount(Math.min(10, this.applications.size()));
        this.applicationBox.addMouseListener((MouseListener)new MouseEventAdapter(){

            public void onDoubleClick(MouseEvent event) {
                ApplicationStarter.this.onStartApplicationButton();
            }
        });
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2), BorderFactory.createTitledBorder("Application:")));
        topPanel.add((Component)new JScrollPane(this.applicationBox), "Center");
        this.parameterTextArea = new JTextArea(5, 10);
        this.parameterTextArea.setLineWrap(true);
        this.parameterTextArea.setWrapStyleWord(true);
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(2, 2, 0, 2), BorderFactory.createTitledBorder("Command Line Arguments:")));
        centerPanel.add((Component)new JScrollPane(this.parameterTextArea), "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout());
        JButton startButton = new JButton("Start");
        startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ApplicationStarter.this.onStartApplicationButton();
            }
        });
        buttonPanel.add(startButton);
        this.frame.add((Component)topPanel, "North");
        this.frame.add((Component)centerPanel, "Center");
        this.frame.add((Component)buttonPanel, "South");
        this.frame.setDefaultCloseOperation(3);
        this.frame.getRootPane().setDefaultButton(startButton);
        this.frame.setMinimumSize(new Dimension(200, 200));
        this.frame.setPreferredSize(new Dimension(400, 400));
        this.frame.pack();
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    protected void onStartApplicationButton() {
        try {
            this.frame.setVisible(false);
            this.frame.dispose();
            this.startApplication((String)this.applicationBox.getSelectedValue(), this.getArgumentsFromTextArea());
        }
        catch (Exception exc) {
            JOptionPane.showMessageDialog(this.frame, exc.getMessage(), "Error starting application", 0);
        }
    }

    private String[] getArgumentsFromTextArea() {
        String[] parameters = new String[]{};
        if (this.parameterTextArea.getText() != null) {
            parameters = StringUtils.split((String)this.parameterTextArea.getText(), (String)" ");
        }
        return parameters;
    }
}

