/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.gui.FilterEntry;
import at.mrdevelopment.toolkit.gui.IconUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collection;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import org.apache.commons.collections15.CollectionUtils;
import org.apache.commons.collections15.Predicate;

public abstract class AbstractFilter<M extends TableModel> {
    protected final JTable table;
    protected final M tableModel;
    protected final List<FilterEntry> filterEntries;
    private final TableRowSorter<M> sorter;
    private JPanel filterPanel;
    private JTextField filterField;
    private JButton filterSelectButton;

    public AbstractFilter(M tableModel, JTable table, List<FilterEntry> filterEntries) {
        this.table = table;
        this.tableModel = tableModel;
        this.filterEntries = filterEntries;
        this.sorter = new TableRowSorter<M>(tableModel);
        table.setRowSorter(this.sorter);
        this.filterField = new JTextField(20);
        this.filterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent event) {
                AbstractFilter.this.applyFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                AbstractFilter.this.applyFilter();
            }

            @Override
            public void changedUpdate(DocumentEvent event) {
                AbstractFilter.this.applyFilter();
            }
        });
        this.filterSelectButton = new JButton();
        this.filterSelectButton.setIcon(IconUtils.loadIcon((String)"down"));
        this.filterSelectButton.setToolTipText("Select columns for filter");
        this.filterSelectButton.setBorder(BorderFactory.createEmptyBorder());
        this.filterSelectButton.setFocusable(false);
        this.filterSelectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractFilter.this.showPopupMenu();
            }
        });
        JLabel label = new JLabel("Filter:");
        label.setLabelFor(this.filterField);
        label.setDisplayedMnemonic(70);
        this.filterField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.getKeyCode() == 10) {
                    AbstractFilter.this.filterField.selectAll();
                }
            }
        });
        this.filterPanel = new JPanel(new FlowLayout(4));
        JPanel componentsPanel = new JPanel(new BorderLayout(5, 0));
        componentsPanel.add((Component)label, "Before");
        componentsPanel.add((Component)this.filterField, "Center");
        componentsPanel.add((Component)this.filterSelectButton, "After");
        this.filterPanel.add(componentsPanel);
    }

    public void reset() {
        this.filterField.setText("");
        this.applyFilter();
    }

    public Component getFilterPanel() {
        return this.filterPanel;
    }

    private void applyFilter() {
        int[] selectedIndices = this.getSelectedIndices();
        if (selectedIndices.length > 0) {
            try {
                RowFilter filter = RowFilter.regexFilter(this.filterField.getText(), selectedIndices);
                this.sorter.setRowFilter(filter);
            }
            catch (PatternSyntaxException ignore) {}
        } else {
            RowFilter filter = new RowFilter<M, Integer>(){

                @Override
                public boolean include(RowFilter.Entry<? extends M, ? extends Integer> entry) {
                    return true;
                }
            };
            this.sorter.setRowFilter(filter);
        }
        if (this.sorter.getViewRowCount() > 0) {
            this.table.changeSelection(0, 0, false, false);
        }
    }

    private void showPopupMenu() {
        JPopupMenu popupMenu = new JPopupMenu();
        for (final FilterEntry filterEntry : this.filterEntries) {
            String name = filterEntry.getName();
            boolean isEnabled = filterEntry.isEnabled();
            final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(name, isEnabled);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    filterEntry.setEnabled(menuItem.isSelected());
                    AbstractFilter.this.applyFilter();
                }
            });
            popupMenu.add(menuItem);
        }
        popupMenu.show(this.filterSelectButton, 3, 3);
    }

    private int[] getSelectedIndices() {
        Collection selectedFilters = CollectionUtils.select(this.filterEntries, (Predicate)new Predicate<FilterEntry>(){

            public boolean evaluate(FilterEntry filterEntry) {
                return filterEntry.isEnabled();
            }
        });
        int[] selectedIndices = new int[selectedFilters.size()];
        int index = 0;
        for (FilterEntry selectedFilter : selectedFilters) {
            selectedIndices[index++] = selectedFilter.getColumnIndex();
        }
        return selectedIndices;
    }
}

