/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.gui;

import at.mrdevelopment.esl.gui.ESLDialog;
import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.gui.GUIUtils;
import at.mrdevelopment.toolkit.image.BufferedImagePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AboutDialog {
    private static final String COMPANY_LOGO = "/images/imagotag.png";

    public AboutDialog(JFrame parentFrame, String applicationName, Version version) throws IOException, URISyntaxException {
        final ESLDialog dialog = new ESLDialog(parentFrame, "About " + applicationName, true);
        dialog.setLayout(new BorderLayout());
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(2);
        dialog.getContentPane().setBackground(Color.WHITE);
        ActionListener closeListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispose();
            }
        };
        JButton okButton = new JButton("OK");
        okButton.setFocusable(false);
        okButton.addActionListener(closeListener);
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(okButton);
        GUIUtils.addEscapeListener((JDialog)dialog, (ActionListener)closeListener);
        JPanel infoPanel = new JPanel(new FlowLayout());
        infoPanel.setBackground(Color.WHITE);
        infoPanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, Color.GRAY));
        infoPanel.add(new JLabel(String.format("%s, Version %s (Build %d)", applicationName, version, version.getBuild())));
        InputStream logoStream = AboutDialog.class.getResourceAsStream(COMPANY_LOGO);
        if (logoStream != null) {
            BufferedImage logo = ImageIO.read(logoStream);
            BufferedImagePanel imagePanel = new BufferedImagePanel(logo, 1.0, 10, Color.WHITE);
            dialog.add((Component)imagePanel, "North");
        }
        dialog.add((Component)infoPanel, "Center");
        dialog.add((Component)buttonPanel, "South");
        dialog.getRootPane().setDefaultButton(okButton);
        dialog.pack();
        dialog.setLocationRelativeTo(parentFrame);
        dialog.setVisible(true);
    }
}

