/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.firmware;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.firmware.Firmware;
import at.mrdevelopment.toolkit.firmware.FirmwareXMLSerializer;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.Key;
import java.security.PublicKey;
import org.bouncycastle.openssl.PEMReader;

public class FirmwareLoader {
    private static final String PUBLIC_KEY = "/licence/licence.public";
    private final FirmwareXMLSerializer firmwareXMLSerializer = new FirmwareXMLSerializer();
    private final PublicKey publicKey = this.readPublicKey();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublicKey readPublicKey() throws InitializationException {
        PublicKey publicKey;
        InputStream inputStream = this.getClass().getResourceAsStream(PUBLIC_KEY);
        PEMReader keyReader = new PEMReader((Reader)new InputStreamReader(inputStream));
        try {
            publicKey = (PublicKey)keyReader.readObject();
        }
        catch (Throwable throwable) {
            try {
                keyReader.close();
                throw throwable;
            }
            catch (IOException exc) {
                throw new InitializationException((Throwable)exc);
            }
        }
        keyReader.close();
        return publicKey;
    }

    public Firmware loadFirmware(String firmwareFilename) throws SerializeException, FileNotFoundException {
        return this.loadFirmware(new File(firmwareFilename));
    }

    public Firmware loadFirmware(File firmwareFile) throws SerializeException, FileNotFoundException {
        FileInputStream inputStream = new FileInputStream(firmwareFile);
        return this.firmwareXMLSerializer.parseXML((InputStream)inputStream, (Key)this.publicKey);
    }
}

