/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.custom;

import at.mrdevelopment.esl.custom.ESLConnector;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.file.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class ConnectorConfiguration {
    private final List<File> configurationFiles = new ArrayList<File>();

    public void addConnectorConfiguration(File configFile) {
        if (configFile != null) {
            this.configurationFiles.add(configFile);
        }
    }

    public Collection<String> loadConnectorClassNames(ClassLoader classLoader, Class<? extends ESLConnector> connectorType) throws InitializationException {
        LinkedList<String> connectorClassNames = new LinkedList<String>();
        for (File file : this.configurationFiles) {
            if (!file.exists()) continue;
            try {
                for (String line : FileUtils.readLines((File)file)) {
                    if (line.startsWith("#") || !this.isConnector(classLoader, connectorType, line.trim())) continue;
                    connectorClassNames.add(line);
                }
            }
            catch (ClassNotFoundException exc) {
                throw new InitializationException((Throwable)exc, "Connector class not found", new Object[0]);
            }
            catch (IOException exc) {
                throw new InitializationException((Throwable)exc, "Could not read configuration file '%s'", new Object[]{file.getAbsolutePath()});
            }
            catch (RuntimeException exc) {
                throw new InitializationException((Throwable)exc, "Unknown error during connector loading", new Object[0]);
            }
        }
        return connectorClassNames;
    }

    private boolean isConnector(ClassLoader classLoader, Class<? extends ESLConnector> connectorType, String className) throws ClassNotFoundException {
        Class<?> type = classLoader.loadClass(className);
        for (Class<?> implementingInterface : type.getInterfaces()) {
            if (implementingInterface != connectorType) continue;
            return true;
        }
        return false;
    }
}

