/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.security;

import at.mrdevelopment.esl.core.security.Pin;
import at.mrdevelopment.esl.wireless.Address;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class Puk {
    private static final int PUK_LENGTH = 16;
    private final byte[] code;
    private final Pin pin;

    public static Puk generate(Random random) {
        byte[] code = new byte[16];
        random.nextBytes(code);
        return new Puk(code);
    }

    public static Puk generateFromAddressAndPhrase(Address address, String phrase) {
        return new Puk(Arrays.copyOf(DigestUtils.sha256((String)(address.toString() + phrase)), 16));
    }

    public static Puk fromBase64(String puk) {
        return new Puk(Arrays.copyOf(new Base64(0).decode(puk), 16));
    }

    public static Puk fromBytes(byte[] bytes) {
        return new Puk(Arrays.copyOf(bytes, 16));
    }

    public static Puk fromHexString(String pukString) {
        return new Puk(Arrays.copyOf(Puk.getBytesFromHexString(pukString), 16));
    }

    private static byte[] getBytesFromHexString(String puk) {
        byte[] pukbytes = new byte[puk.length() / 2];
        for (int index = 0; index < puk.length(); index += 2) {
            pukbytes[index / 2] = (byte)((Character.digit(puk.charAt(index), 16) << 4) + Character.digit(puk.charAt(index + 1), 16));
        }
        return pukbytes;
    }

    private Puk(byte[] code) {
        this.code = code;
        this.pin = Pin.fromPuk(this);
    }

    public Pin getPin() {
        return this.pin;
    }

    public String toBase64() {
        return new Base64(0).encodeToString(this.code);
    }

    public String toHex() {
        return Hex.encodeHexString((byte[])this.toBytes());
    }

    public byte[] toBytes() {
        return this.code;
    }

    public String toString() {
        return this.toBase64();
    }
}

