/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.security;

import at.mrdevelopment.esl.core.security.InitializationVector;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;

public class Nonce {
    private static final int NONCE_LENGTH = 16;
    private final byte[] bytes;

    public static Nonce generate(Random random) {
        byte[] bytes = new byte[16];
        random.nextBytes(bytes);
        return new Nonce(bytes);
    }

    public static Nonce deriveIncremented(Nonce nonce) {
        byte[] incremented = nonce.toBigInteger().add(BigInteger.ONE).toByteArray();
        return new Nonce(Arrays.copyOfRange(incremented, Math.max(0, incremented.length - 16), incremented.length));
    }

    public static Nonce fromHexString(String hexString) {
        byte[] bytes = new BigInteger(hexString, 16).toByteArray();
        return new Nonce(Arrays.copyOfRange(bytes, Math.max(0, bytes.length - 16), bytes.length));
    }

    private Nonce(byte[] bytes) {
        this.bytes = bytes;
    }

    public String toBase64() {
        return new Base64(0).encodeToString(this.bytes);
    }

    public BigInteger toBigInteger() {
        return new BigInteger(this.bytes);
    }

    public InitializationVector toIv() {
        return InitializationVector.fromNonce(this);
    }

    public byte[] toBytes() {
        return this.bytes;
    }

    public String toHexString() {
        return this.toBigInteger().toString(16);
    }

    public String toString() {
        return this.toBase64();
    }
}

