/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.labeltype;

import at.mrdevelopment.esl.core.Page;
import at.mrdevelopment.esl.core.labeltype.DisplayColors;
import at.mrdevelopment.esl.core.labeltype.DisplayDriving;
import at.mrdevelopment.toolkit.image.ColorMapping;
import at.mrdevelopment.toolkit.image.RawImageType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum LabelType {
    UNKNOWN(true, "Unknown label type", 0, 0, 0, DisplayTechnology.UNKNOWN, DisplayDriving.UNKNOWN, DisplayColors.UNKNOWN, RFTechnology.UNKNONW, PowerSource.UNKNOWN, 15, Page.REGISTRATION, Page.RESET, false, true, new HardwareFeature[0]),
    BATTERY_144(true, "G1 1.4", 128, 96, 111, DisplayTechnology.E_INK_V110, DisplayDriving.COG, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 15, Page.REGISTRATION, Page.RESET, false, true, new HardwareFeature[0]),
    BATTERY_144_FLIPPED(true, "G1 1.4", 128, 96, 111, DisplayTechnology.E_INK_V110, DisplayDriving.COG, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 15, Page.REGISTRATION, Page.RESET, true, true, new HardwareFeature[0]),
    BATTERY_190(true, "G1 1.9", 144, 128, 102, DisplayTechnology.E_INK_V110, DisplayDriving.COG, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 15, Page.REGISTRATION, Page.RESET, false, true, new HardwareFeature[0]),
    BATTERY_200(false, "G1 2.0", 200, 96, 111, DisplayTechnology.E_INK_V110, DisplayDriving.COG, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 10, Page.PAGE_8, Page.PAGE_9, false, true, new HardwareFeature[0]),
    BATTERY_200_FLIPPED(true, "G1 2.0", 200, 96, 111, DisplayTechnology.E_INK_V110, DisplayDriving.COG, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 10, Page.PAGE_8, Page.PAGE_9, true, true, new HardwareFeature[0]),
    BATTERY_270(false, "G1 2.7", 264, 176, 117, DisplayTechnology.E_INK_V110, DisplayDriving.COG, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 10, Page.PAGE_8, Page.PAGE_9, false, true, new HardwareFeature[0]),
    BATTERY_270_FLIPPED(false, "G1 2.7", 264, 176, 117, DisplayTechnology.E_INK_V110, DisplayDriving.COG, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 10, Page.PAGE_8, Page.PAGE_9, true, true, new HardwareFeature[0]),
    BATTERY_270_BILLA(false, "Billa Bestpreis 2.7", 264, 176, 117, DisplayTechnology.E_INK_V220, DisplayDriving.COG, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 10, Page.PAGE_8, Page.PAGE_9, false, true, new HardwareFeature[0]),
    BATTERY_441(false, "G1 4.4", 400, 300, 113, DisplayTechnology.E_INK_V110, DisplayDriving.TCON, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 14, Page.PAGE_12, Page.PAGE_13, false, true, new HardwareFeature[0]),
    BATTERY_441_FLIPPED(true, "G1 4.4", 400, 300, 113, DisplayTechnology.E_INK_V110, DisplayDriving.TCON, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 14, Page.PAGE_12, Page.PAGE_13, true, true, new HardwareFeature[0]),
    BATTERY_441_SPECTRA(true, "G1 4.4 Spectra", 400, 300, 113, DisplayTechnology.E_INK_SPECTRA, DisplayDriving.TCON, DisplayColors.BLACK_WHITE_RED, RFTechnology.CC251X, PowerSource.BATTERY, 15, Page.PAGE_12, Page.PAGE_13, false, true, new HardwareFeature[0]),
    BATTERY_740(false, "G1 7.4", 480, 800, 126, DisplayTechnology.E_INK_V110, DisplayDriving.TCON, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 14, Page.PAGE_12, Page.PAGE_13, false, true, new HardwareFeature[0]),
    BATTERY_740_FLIPPED(true, "G1 7.4", 480, 800, 126, DisplayTechnology.E_INK_V110, DisplayDriving.TCON, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 14, Page.PAGE_12, Page.PAGE_13, true, true, new HardwareFeature[0]),
    BATTERY_740_SPECTRA(true, "G1 7.4 Spectra", 480, 800, 126, DisplayTechnology.E_INK_SPECTRA, DisplayDriving.TCON, DisplayColors.BLACK_WHITE_RED, RFTechnology.CC251X, PowerSource.BATTERY, 15, Page.REGISTRATION, Page.RESET, false, true, new HardwareFeature[0]),
    BATTERY_1020(false, "G1 10.2", 1024, 1280, 160, DisplayTechnology.E_INK_V110, DisplayDriving.TCON_1020, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 15, Page.REGISTRATION, Page.RESET, false, true, new HardwareFeature[0]),
    BATTERY_1020_FLIPPED(true, "G1 10.2", 1024, 1280, 160, DisplayTechnology.E_INK_V110, DisplayDriving.TCON_1020, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 15, Page.REGISTRATION, Page.RESET, true, true, new HardwareFeature[0]),
    SOLAR_200(true, "G1 2.0 Solar", 200, 96, 111, DisplayTechnology.E_INK_V110, DisplayDriving.COG, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.PHOTOVOLTAICS, 15, Page.REGISTRATION, Page.RESET, true, true, new HardwareFeature[0]),
    SOLAR_270(true, "G1 2.7 Solar", 264, 176, 117, DisplayTechnology.E_INK_V110, DisplayDriving.COG, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.PHOTOVOLTAICS, 15, Page.REGISTRATION, Page.RESET, false, true, new HardwareFeature[0]),
    BATTERY_SEGMENTED(false, "Segmented", 128, 1, 0, DisplayTechnology.E_INK_SEGMENTED, DisplayDriving.TCON, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 2, Page.REGISTRATION, Page.RESET, false, false, new HardwareFeature[0]),
    SES_GTAG_6(true, "SES G-tag 6+ HF", 256, 128, 127, DisplayTechnology.DTP_LCD, DisplayDriving.DC2_COMPRESSED, DisplayColors.MONOCHROM, RFTechnology.CC251X, PowerSource.BATTERY, 15, Page.REGISTRATION, Page.RESET, false, false, new HardwareFeature[0]);

    private final boolean hidden;
    private final String name;
    private final int displayWidth;
    private final int displayHeight;
    private final int displayDpi;
    private final DisplayColors displayColors;
    private final DisplayTechnology displayTechnology;
    private final DisplayDriving displayDriving;
    private final RFTechnology rfTechnology;
    private final PowerSource powerSource;
    private final int pageCount;
    private final Page registrationPage;
    private final Page resetPage;
    private final boolean flipImage;
    private final boolean compressionAllowed;
    private final Set<HardwareFeature> hardwareFeatures;

    private LabelType(boolean hidden, String name, int displayWidth, int displayHeight, int displayDpi, DisplayTechnology displayTechnology, DisplayDriving displayDriving, DisplayColors displayColors, RFTechnology rfTechnology, PowerSource powerSource, int pageCount, Page registrationPage, Page resetPage, boolean flipImage, boolean compressionAllowed, HardwareFeature ... hardwareFeatures) {
        if (pageCount < 2) {
            throw new IllegalArgumentException("Page count must be at least 2");
        }
        this.hidden = hidden;
        this.name = name;
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        this.displayDpi = displayDpi;
        this.displayColors = displayColors;
        this.displayDriving = displayDriving;
        this.displayTechnology = displayTechnology;
        this.rfTechnology = rfTechnology;
        this.powerSource = powerSource;
        this.pageCount = pageCount;
        this.registrationPage = registrationPage;
        this.resetPage = resetPage;
        this.flipImage = flipImage;
        this.compressionAllowed = compressionAllowed;
        this.hardwareFeatures = new HashSet<HardwareFeature>(Arrays.asList(hardwareFeatures));
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getName() {
        return this.name;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public int getDisplayDpi() {
        return this.displayDpi;
    }

    public DisplayTechnology getDisplayTechnology() {
        return this.displayTechnology;
    }

    public DisplayDriving getDisplayDriving() {
        return this.displayDriving;
    }

    public DisplayColors getDisplayColors() {
        return this.displayColors;
    }

    public RawImageType getRawImageType() {
        return this.displayColors.getRawImageType();
    }

    public ColorMapping[] getColorMappings() {
        return this.displayColors.getColorMappings();
    }

    public RFTechnology getRfTechnology() {
        return this.rfTechnology;
    }

    public PowerSource getPowerSource() {
        return this.powerSource;
    }

    public int getAvailablePageCount() {
        return this.pageCount - 2;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public Page getRegistrationPage() {
        return this.registrationPage;
    }

    public Page getResetPage() {
        return this.resetPage;
    }

    public boolean isFlipImage() {
        return this.flipImage;
    }

    public boolean isSegmented() {
        return this.displayTechnology == DisplayTechnology.E_INK_SEGMENTED;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public Set<HardwareFeature> getHardwareFeatures() {
        return Collections.unmodifiableSet(this.hardwareFeatures);
    }

    public boolean hasHardwareFeatures(HardwareFeature hardwareFeature) {
        return this.hardwareFeatures.contains((Object)hardwareFeature);
    }

    public static LabelType fromString(String name) {
        try {
            return LabelType.valueOf(name);
        }
        catch (Exception exc) {
            return UNKNOWN;
        }
    }

    public boolean isCompressionAllowed() {
        return this.compressionAllowed;
    }

    public static enum HardwareFeature {
        NFC;

    }

    public static enum PowerSource {
        UNKNOWN,
        BATTERY,
        PHOTOVOLTAICS;

    }

    public static enum RFTechnology {
        UNKNONW,
        CC251X;

    }

    public static enum DisplayTechnology {
        UNKNOWN,
        E_INK_V110,
        E_INK_V220,
        E_INK_V230,
        E_INK_SPECTRA,
        DTP_LCD,
        E_INK_SEGMENTED;

    }
}

