/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core.labeltype;

import at.mrdevelopment.toolkit.encoding.dc2.Binary;
import at.mrdevelopment.toolkit.encoding.dc2.CompressionDC2;
import at.mrdevelopment.toolkit.encoding.dc2.ImageBinary;
import at.mrdevelopment.toolkit.image.RawImage;

public enum DisplayDriving {
    UNKNOWN,
    TCON,
    DC2_COMPRESSED{

        @Override
        public byte[] toImage(RawImage image) {
            ImageBinary imageBinary = new ImageBinary(image.getBytes(), image.getWidth(), image.getHeight());
            CompressionDC2 dc2 = new CompressionDC2();
            Binary output = dc2.compress(imageBinary);
            return output.getData();
        }
    }
    ,
    COG{

        @Override
        public byte[] toImage(RawImage image) {
            byte[] targetBytes = new byte[image.getSize()];
            byte[] sourceBytes = image.getBytes();
            int lines = image.getHeight();
            int bytesPerLine = image.getWidth() / 8;
            for (int y = 0; y < lines; ++y) {
                int yOffset = bytesPerLine * y;
                for (int x = 0; x < bytesPerLine; ++x) {
                    byte source = sourceBytes[yOffset + x];
                    byte high = (byte)(source & 0x80 | (source & 0x20) << 1 | (source & 8) << 2 | (source & 2) << 3);
                    source = sourceBytes[yOffset + (bytesPerLine - (x + 1))];
                    byte low = (byte)((source & 1) << 3 | source & 4 | (source & 0x10) >> 3 | (source & 0x40) >> 6);
                    targetBytes[yOffset + x] = (byte)(high | low);
                }
            }
            return targetBytes;
        }

        @Override
        public byte[] toDisplay(RawImage image) {
            byte[] targetBytes = new byte[image.getSize()];
            byte[] sourceBytes = image.getBytes();
            int lines = image.getHeight();
            int bytesPerLine = image.getWidth() / 8;
            for (int y = 0; y < lines; ++y) {
                int yOffset = bytesPerLine * y;
                for (int x = 0; x < bytesPerLine; ++x) {
                    byte source = sourceBytes[yOffset + x];
                    byte high = (byte)(source & 0x80 | (source & 0x40) >> 1 | (source & 0x20) >> 2 | (source & 0x10) >> 3);
                    byte low = (byte)((source & 8) >> 3 | source & 4 | (source & 2) << 3 | (source & 1) << 6);
                    int n = yOffset + x;
                    targetBytes[n] = (byte)(targetBytes[n] | high);
                    int n2 = yOffset + (bytesPerLine - (x + 1));
                    targetBytes[n2] = (byte)(targetBytes[n2] | low);
                }
            }
            return targetBytes;
        }
    }
    ,
    TCON_1020{

        @Override
        public byte[] toImage(RawImage image) {
            byte[] targetBytes = new byte[image.getSize()];
            byte[] sourceBytes = image.getBytes();
            int lines = image.getHeight();
            int bytesPerLine = image.getWidth() / 8;
            for (int y = 0; y < lines; ++y) {
                int yOffset = bytesPerLine * y;
                for (int x = 0; x < bytesPerLine; ++x) {
                    byte source = sourceBytes[yOffset + x];
                    source = (byte)((source & 0x55) << 1 | source >>> 1 & 0x55);
                    source = (byte)((source & 0x33) << 2 | source >>> 2 & 0x33);
                    targetBytes[yOffset + bytesPerLine - x - 1] = source = (byte)((source & 0xF) << 4 | source >>> 4 & 0xF);
                }
            }
            return targetBytes;
        }
    };


    public byte[] toImage(RawImage image) {
        return image.getBytes();
    }

    public byte[] toDisplay(RawImage image) {
        return image.getBytes();
    }
}

