/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.Status;

public enum UpdateTaskStatus {
    WAITING,
    SENDING,
    SUCCESSFUL,
    CANCELED,
    FAILED,
    ERROR;


    public boolean isWaiting() {
        return this == WAITING;
    }

    public boolean isSending() {
        return this == SENDING;
    }

    public boolean isSuccessful() {
        return this == SUCCESSFUL;
    }

    public boolean isCanceled() {
        return this == CANCELED;
    }

    public boolean isFailed() {
        return this == FAILED;
    }

    public boolean isError() {
        return this == ERROR;
    }

    public boolean isUnsuccessful() {
        return this == FAILED || this == ERROR;
    }

    public boolean isFinished() {
        return this.isCanceled() || this.isUnsuccessful() || this.isSuccessful();
    }

    public Status toStatus() {
        if (this == WAITING) {
            return Status.WAITING;
        }
        if (this == SENDING) {
            return Status.WAITING;
        }
        if (this == SUCCESSFUL) {
            return Status.SUCCESSFUL;
        }
        if (this == CANCELED) {
            return Status.CANCELED;
        }
        if (this == FAILED) {
            return Status.FAILED;
        }
        if (this == ERROR) {
            return Status.ERROR;
        }
        throw new RuntimeException();
    }
}

