/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.LinkQuality;

public class SyncQuality {
    private static final int SYNC_QUALITY_SYNC_COUNT_MASK = 240;
    private static final int SYNC_QUALITY_RSSI_LEVEL_MASK = 12;
    private static final int SYNC_QUALITY_LQI_LEVEL_MASK = 3;
    private static final int SYNC_QUALITY_SYNC_COUNT_FACTOR = 16;
    private static final int SYNC_QUALITY_SYNC_COUNT_MINUTES_PER_COUNT = 4;
    private static final int SYNC_QUALITY_SYNC_COUNT_MAX = 15;
    private final int syncQuality;

    public static SyncQuality valueOf(String syncQualityString) {
        return new SyncQuality(Integer.parseInt(syncQualityString));
    }

    public SyncQuality(int syncQuality) {
        if (syncQuality < 0 || syncQuality > 255) {
            throw new IllegalArgumentException("Sync quality is out of valid range");
        }
        this.syncQuality = syncQuality;
    }

    public int getSyncQualityValue() {
        return this.syncQuality;
    }

    public int getContinuousSyncCount() {
        return ((this.syncQuality & 0xF0) >> 4) * 16;
    }

    public int getContinuousSyncMinutes() {
        return ((this.syncQuality & 0xF0) >> 4) * 4;
    }

    public boolean isContinuousSyncCountExceeded() {
        return (this.syncQuality & 0xF0) >> 4 == 15;
    }

    public String getContinuousSyncTimeString() {
        if (this.isContinuousSyncCountExceeded()) {
            return String.format("> %d minutes", this.getContinuousSyncMinutes());
        }
        return String.format("%d to %d minutes", this.getContinuousSyncMinutes(), this.getContinuousSyncMinutes() + 4);
    }

    public LinkQuality getSyncRssiLevel() {
        return LinkQuality.valueOf((this.syncQuality & 0xC) >> 2);
    }

    public LinkQuality getSyncLqiLevel() {
        return LinkQuality.valueOf(this.syncQuality & 3);
    }

    public LinkQuality getSyncQualityLevel() {
        int rssiQuality = this.getSyncRssiLevel().getQualityLevel();
        int lqiQuality = this.getSyncLqiLevel().getQualityLevel();
        return LinkQuality.valueOf(Math.min(rssiQuality, lqiQuality));
    }

    public String toString() {
        return this.getSyncQualityLevel().toString();
    }
}

