/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import java.net.MalformedURLException;
import java.net.URL;

public class ServiceAddress {
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private final boolean ssl;
    private final String host;
    private final int port;
    private final String username;
    private final String password;

    public ServiceAddress(boolean ssl, String host, int port, String username, String password) {
        this.ssl = ssl;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
    }

    public ServiceAddress(boolean ssl, String host, int port) {
        this(ssl, host, port, null, null);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean useSSL() {
        return this.ssl;
    }

    public String getProtocol() {
        return this.ssl ? "https" : "http";
    }

    public boolean hasCredentials() {
        return this.username != null && this.password != null;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getConnectionString() {
        return String.format("%s://%s%s:%d/", this.getProtocol(), this.hasCredentials() ? String.format("%s:%s@", this.username, this.password) : "", this.host, this.port);
    }

    public String toString() {
        return String.format("%s://%s:%d/", this.getProtocol(), this.host, this.port);
    }

    public static ServiceAddress fromString(String addressString) throws MalformedURLException {
        URL url = new URL(addressString);
        boolean ssl = url.getProtocol().matches("https");
        String host = url.getHost();
        int port = url.getPort();
        String userInfo = url.getUserInfo();
        String username = null;
        String password = null;
        if (host == null) {
            throw new MalformedURLException("Host is null");
        }
        if (port == -1) {
            port = ssl ? 443 : 80;
        } else if (port < 0 || port > 65535) {
            throw new MalformedURLException("Illegal port (must be between 0 and 65535)");
        }
        if (!url.getProtocol().equals("http") && !url.getProtocol().equals("https")) {
            throw new MalformedURLException("Unsupported protocol (must be http or https)");
        }
        if (userInfo != null) {
            String[] splittedUserInfo = userInfo.split(":");
            username = splittedUserInfo[0];
            if (splittedUserInfo.length == 2) {
                password = splittedUserInfo[1];
            }
        }
        return new ServiceAddress(ssl, host, port, username, password);
    }
}

