/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.toolkit.Version;

public enum SecurityStatus {
    AES128("Communication with label is encrypted with 128 bit AES"),
    UNSUPPORTED("Encryption is not supported by label firmware"),
    KEY_UNSET("Communication is NOT yet encrypted"),
    NO_PIN("Could net set encryption key as no PIN (registration code) was provided"),
    UNKNOWN("Security status is not determined yet");

    private final String description;

    private SecurityStatus(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isEncrypted() {
        return this == AES128;
    }

    public boolean isEncryptionSupported() {
        return this != UNSUPPORTED && this != UNKNOWN;
    }

    public static SecurityStatus fromString(String value) {
        return SecurityStatus.valueOf(value.toUpperCase());
    }

    public static SecurityStatus valueOf(Version firmware, boolean keyUnset, boolean keysNotProgrammed, boolean pinProvided) {
        if (firmware == null) {
            return UNKNOWN;
        }
        if (firmware.getMainRelease() < 3) {
            return UNSUPPORTED;
        }
        if (keysNotProgrammed) {
            return UNSUPPORTED;
        }
        if (keyUnset) {
            return pinProvided ? KEY_UNSET : NO_PIN;
        }
        return AES128;
    }
}

