/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.PeriodicTasksExecutor;
import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;

public abstract class ReloadRunner
implements Runnable,
Shutdownable {
    static ESLLogger logger = ESLLogger.getLogger(ReloadRunner.class);
    private final PeriodicTasksExecutor executor;
    private volatile boolean shutdownRequested = false;

    public static Shutdownable startInBackground(ReloadRunner reloadRunner, boolean interruptOnShutdown) {
        String name = "TasksExecutor." + reloadRunner.executor.getClass().getSimpleName();
        ReloadThread reloadThread = new ReloadThread(name, reloadRunner, interruptOnShutdown);
        reloadThread.start();
        return reloadThread;
    }

    public static void startInCurrentThread(ReloadRunner reloadRunner) {
        reloadRunner.run();
    }

    protected ReloadRunner(PeriodicTasksExecutor executor) {
        this.executor = executor;
    }

    @Override
    public void run() {
        while (!this.shutdownRequested && !this.executor.isFinished()) {
            try {
                this.executor.performPeriodicTasks();
                long reloadTime = this.getReloadTime();
                if (reloadTime <= 0L) continue;
                Thread.sleep(reloadTime);
            }
            catch (InterruptedException ignore) {
            }
            catch (RuntimeException exc) {
                logger.logException((Throwable)exc);
            }
        }
        logger.info("Finished executor %s", new Object[]{this.executor.getClass().getName()});
    }

    protected abstract long getReloadTime();

    public void shutdown() {
        this.shutdownRequested = true;
    }

    private static class ReloadThread
    extends Thread
    implements Shutdownable {
        private final Shutdownable shutdownable;
        private final boolean interruptOnShutdown;

        public ReloadThread(String name, ReloadRunner reloadRunner, boolean interruptOnShutdown) {
            super((Runnable)reloadRunner, name);
            this.shutdownable = reloadRunner;
            this.interruptOnShutdown = interruptOnShutdown;
        }

        public void shutdown() {
            this.shutdownable.shutdown();
            if (this.interruptOnShutdown) {
                this.interrupt();
            }
        }
    }
}

