/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

public enum PowerStatus {
    GOOD("Good power status"),
    LOW("Battery replacement required within a few weeks (if label is battery powered)"),
    BAD("Immediate battery replacement required (if label is battery powered)"),
    UNKNOWN("No recent power sensor value available");

    private final String description;

    private PowerStatus(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isGood() {
        return this == GOOD;
    }

    public boolean isLow() {
        return this == LOW;
    }

    public boolean isBad() {
        return this == BAD;
    }

    public boolean isUnknown() {
        return this == UNKNOWN;
    }

    public static PowerStatus fromString(String value) {
        return PowerStatus.valueOf(value.toUpperCase());
    }

    public static PowerStatus valueOf(int powerStatus) {
        switch (powerStatus) {
            case 0: {
                return BAD;
            }
            case 1: {
                return LOW;
            }
            case 2: {
                return GOOD;
            }
        }
        return UNKNOWN;
    }

    public boolean isOk() {
        return this.isGood() || this.isLow();
    }
}

