/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.toolkit.datetime.ReadableTimeFormatter;
import org.joda.time.DateTime;

public class LabelConfigConverter {
    private static final String UNIT_VOLTAGE = "V";
    private static final String UNIT_RESISTANCE = "Ohm";

    public static double convertBatteryThresholdForSmallPrints(int voltage) {
        return (double)voltage * 2047.0 / 3.3 / Math.pow(2.0, 3.0);
    }

    public static int reconvertBatteryThresholdForSmallPrints(double value) {
        return (int)(value / 2047.0 * 3.3 * Math.pow(2.0, 3.0));
    }

    public static String convertBatteryThresholdForSmallPrintsString(int voltage) {
        return String.format("%d %s", LabelConfigConverter.convertBatteryThresholdForSmallPrints(voltage), UNIT_RESISTANCE);
    }

    public static double convertBatteryThresholdRIOld(int voltage) {
        return (double)voltage * 2047.0 / 3.3 / Math.pow(2.0, 3.0);
    }

    public static int reconvertBatteryThresholdRIOld(double value) {
        return (int)(value / 2047.0 * 3.3 * Math.pow(2.0, 3.0));
    }

    public static String convertBatteryThresholdRIOldString(int voltage) {
        return String.format("%d %s", LabelConfigConverter.convertBatteryThresholdRIOldString(voltage), UNIT_RESISTANCE);
    }

    public static double convertBatteryThresholdRI(int resistance) {
        return (double)resistance * 2048.0 / (3750.0 * Math.pow(2.0, -4.0));
    }

    public static int reconvertBatteryThresholdRI(double value) {
        return (int)(value * 1.25 * 3.0 * 1000.0 * Math.pow(2.0, -4.0) / 2048.0);
    }

    public static String convertBatteryThresholdRIString(int resistance) {
        return String.format("%d %s", LabelConfigConverter.convertBatteryThresholdRI(resistance), UNIT_RESISTANCE);
    }

    public static double convertPowerStatusAcceptVoltageThreshold(int voltage) {
        return (double)voltage / 3.0 * 2048.0 / 1.25 / Math.pow(2.0, 3.0);
    }

    public static int reconvertPowerStatusAcceptVoltageThreshold(double value) {
        return (int)(value * 3.0 / 2048.0 * 1.25 * Math.pow(2.0, 3.0));
    }

    public static String convertPowerStatusAcceptVoltageThresholdString(int voltage) {
        return String.format("%d %s", LabelConfigConverter.convertPowerStatusAcceptVoltageThreshold(voltage), UNIT_VOLTAGE);
    }

    public static int convertSenseInterval(int rawValue) {
        return rawValue * 15;
    }

    public static String convertSenseIntervalString(int rawValue) {
        DateTime dateTime = DateTime.now();
        DateTime dateTime2 = dateTime.plusMinutes(LabelConfigConverter.convertSenseInterval(rawValue));
        return ReadableTimeFormatter.printElapsedTime((long)dateTime.getMillis(), (long)dateTime2.getMillis());
    }

    public static int reconvertSenseIntervalString(int value) {
        return value / 15;
    }
}

