/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.LoggerUserInfo;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.userinfo.UserInfo;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.comparator.NameFileComparator;
import org.apache.commons.lang.StringUtils;

public abstract class FixturesImport {
    static ESLLogger logger = ESLLogger.getLogger(FixturesImport.class);
    public static final File DEFAULT_FIXTURES_DIRECTORY = new File("data/fixtures");
    private static final String FILE_NUMERATION_SEPARATOR = "_";
    private final UserInfo userInfo;

    public FixturesImport() {
        this(new LoggerUserInfo(logger));
    }

    public FixturesImport(UserInfo userInfo) {
        this.userInfo = userInfo;
    }

    public void importFixtures(File[] fixturesFiles) throws Exception {
        if (fixturesFiles != null) {
            Arrays.sort(fixturesFiles, NameFileComparator.NAME_COMPARATOR);
            for (File fixtureFile : fixturesFiles) {
                if (!fixtureFile.exists() || !fixtureFile.isFile()) continue;
                if (FilenameUtils.isExtension((String)fixtureFile.getPath(), (String)"xml")) {
                    this.userInfo.addInfo("Loading fixture from '%s'", new Object[]{fixtureFile.getPath()});
                    this.importFixture(fixtureFile);
                    continue;
                }
                this.userInfo.addWarning("Ignoring fixture '%s' with unsupported file type", new Object[]{fixtureFile.getPath()});
            }
        }
    }

    public void importFixtures(File fixturesDirectory) throws Exception {
        if (!fixturesDirectory.exists() || !fixturesDirectory.isDirectory()) {
            return;
        }
        this.userInfo.addInfo("Loading fixtures from directory '%s'", new Object[]{fixturesDirectory.getPath()});
        this.importFixtures(fixturesDirectory.listFiles());
    }

    protected abstract void importFixture(File var1) throws Exception;

    protected UserInfo getUserInfo() {
        return this.userInfo;
    }

    protected String parseEntityName(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException();
        }
        String basename = FilenameUtils.getBaseName((String)file.getPath());
        String[] tokens = StringUtils.split((String)basename, (String)FILE_NUMERATION_SEPARATOR);
        if (tokens.length == 1) {
            return tokens[0];
        }
        if (tokens.length >= 2) {
            return tokens[1];
        }
        throw new IOException("Failed to parse entity name from filename");
    }
}

