/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.toolkit.file.FileUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.io.IOException;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public class ESLSystemDefaults {
    static ESLLogger logger = ESLLogger.getLogger(ESLSystemDefaults.class);
    private static final String CONFIG_FILE_NAME = "defaults.config";
    public static final String DEFAULT_ACCESS_POINT_ADMINISTRATION_USERNAME = "admin";
    public static final String DEFAULT_ACCESS_POINT_ADMINISTRATION_PASSWORD = "admin";
    public static final int DEFAULT_ACCESS_POINT_TCP_LISTEN_PORT = 8080;
    public static final boolean DEFAULT_ACCESS_POINT_USE_SSL = false;
    public static final String DEFAULT_SERVER_ADMINISTRATOR_USERNAME = "admin";
    public static final String DEFAULT_SERVER_USER_USERNAME = "esl";
    public static final String DEFAULT_SERVER_READONLY_USERNAME = "readonly";
    public static final int DEFAULT_SERVER_TCP_LISTEN_PORT = 8000;
    public static final boolean DEFAULT_SERVER_USE_SSL = false;
    public static int DEFAULT_DISCOVERY_BROADCAST_PORT = 8000;
    private boolean useSSL = false;
    private int servicePort = 8000;

    public ESLSystemDefaults() throws IOException {
        this.parseFromFile(new File(FilenameUtils.concat((String)FilenameUtils.concat((String)System.getProperty("user.home"), (String)".esl"), (String)CONFIG_FILE_NAME)));
        this.parseFromFile(new File(FilenameUtils.concat((String)new File("../common").getAbsolutePath(), (String)CONFIG_FILE_NAME)));
        this.parseFromFile(new File(FilenameUtils.concat((String)"config", (String)CONFIG_FILE_NAME)));
    }

    private void parseFromFile(File configFile) throws IOException {
        logger.info("Loading system defaults from %s", new Object[]{configFile.getAbsolutePath()});
        if (configFile.exists()) {
            String[] args = StringUtils.split((String)FileUtils.read((File)configFile));
            this.parseSystemDefaults(args);
        }
    }

    private void parseSystemDefaults(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec optionServicePort = parser.accepts("port").withRequiredArg().ofType(Integer.class);
        ArgumentAcceptingOptionSpec optionUseSSL = parser.accepts("ssl").withRequiredArg().ofType(Boolean.class);
        OptionSet options = parser.parse(args);
        if (options.has((OptionSpec)optionUseSSL)) {
            this.useSSL = (Boolean)options.valueOf((OptionSpec)optionUseSSL);
        }
        if (options.has((OptionSpec)optionServicePort)) {
            this.servicePort = (Integer)options.valueOf((OptionSpec)optionServicePort);
        }
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }

    public int getServicePort() {
        return this.servicePort;
    }
}

