/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.core;

import at.mrdevelopment.esl.core.BatteryResistanceSensor;
import at.mrdevelopment.esl.core.McuSupplyVoltageSensor;
import at.mrdevelopment.esl.core.PowerVoltageSensor;
import at.mrdevelopment.esl.core.RawSensor;
import at.mrdevelopment.esl.core.RawTemperatureSensor;
import at.mrdevelopment.esl.core.SensorConversion;
import at.mrdevelopment.esl.core.TemperatureSensor;
import at.mrdevelopment.esl.updatetask.LabelSensor;

public class AutoSensor
implements SensorConversion<Object> {
    private static final String SENSOR_NAME = "Auto Sensor";
    private static final int SENSOR_COUNT = 16;
    private static final SensorConversion<?>[] SENSORS = new SensorConversion[16];
    private static final SensorConversion<?> RAW_SENSOR = new RawSensor();

    @Override
    public String getSensorName() {
        return SENSOR_NAME;
    }

    @Override
    public Object getValue(int rawSensorValue) {
        return this.getSensor(rawSensorValue).getValue(rawSensorValue);
    }

    @Override
    public String getValueString(int rawSensorValue) {
        return this.getSensor(rawSensorValue).getValueString(rawSensorValue);
    }

    private int getSensorType(int rawSensorValue) {
        return (rawSensorValue & 0xF000) >> 12;
    }

    private SensorConversion<?> getSensor(int rawSensorValue) {
        int sensorType = this.getSensorType(rawSensorValue);
        return SENSORS[sensorType] != null ? SENSORS[sensorType] : RAW_SENSOR;
    }

    static {
        AutoSensor.SENSORS[LabelSensor.TEMPERATURE_RAW_ADC_SENSOR.getSensorId()] = new RawTemperatureSensor();
        AutoSensor.SENSORS[LabelSensor.TEMPERATURE_SENSOR.getSensorId()] = new TemperatureSensor();
        AutoSensor.SENSORS[LabelSensor.POWER_VOLTAGE_SENSOR.getSensorId()] = new PowerVoltageSensor();
        AutoSensor.SENSORS[LabelSensor.MCU_SUPPLY_VOLTAGE_SENSOR.getSensorId()] = new McuSupplyVoltageSensor();
        AutoSensor.SENSORS[LabelSensor.BATTERY_RESISTANCE_SENSOR.getSensorId()] = new BatteryResistanceSensor();
    }
}

