/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.certificate;

import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class SelfSignedCertificateGenerator {
    private static X509Certificate generateV3Certificate(String hostname, KeyPair keyPair) throws InvalidKeyException, NoSuchProviderException, SignatureException {
        X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
        v3CertGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        v3CertGen.setIssuerDN((X509Name)new X509Principal("CN=" + hostname + ", OU=None, O=None, L=None, C=None"));
        v3CertGen.setNotBefore(new Date(System.currentTimeMillis() - 2592000000L));
        v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 315360000000L));
        v3CertGen.setSubjectDN((X509Name)new X509Principal("CN=" + hostname + ", OU=None, O=None, L=None, C=None"));
        v3CertGen.setPublicKey(keyPair.getPublic());
        v3CertGen.setSignatureAlgorithm("MD5WithRSAEncryption");
        X509Certificate certificate = v3CertGen.generateX509Certificate(keyPair.getPrivate());
        return certificate;
    }

    private static String getHostName() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            return localHost.getHostName();
        }
        catch (UnknownHostException exc) {
            return "localhost";
        }
    }

    public static void main(String[] args) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(1024);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        String hostName = SelfSignedCertificateGenerator.getHostName();
        X509Certificate certificate = SelfSignedCertificateGenerator.generateV3Certificate(hostName, keyPair);
        certificate.checkValidity(new Date());
        certificate.verify(certificate.getPublicKey());
        System.out.println(certificate.toString());
        System.out.println("valid certificate generated");
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

