/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.certificate;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;

public class ImportKey {
    public static void main(String[] args) {
        if (args.length != 2 && args.length != 3) {
            System.out.println("Usage: java ImportKey certfile keyfile");
            System.exit(0);
        }
        String keystoreName = args[0];
        String certFile = args[1];
        String keyFile = args.length == 3 ? args[2] : null;
        try {
            System.out.println("Using keystore file: " + keystoreName);
            ImportKey.importKey(keystoreName, certFile, keyFile);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    public static void importKey(String keystoreName, String certificateFile, String privateKeyFile) throws KeyStoreException, NoSuchProviderException, NoSuchAlgorithmException, CertificateException, IOException, InvalidKeySpecException {
        String password = "imagotag";
        String alias = "imagotag";
        KeyStore keyStore = KeyStore.getInstance("JKS", "SUN");
        keyStore.load(null, password.toCharArray());
        keyStore.store(new FileOutputStream(keystoreName), password.toCharArray());
        keyStore.load(new FileInputStream(keystoreName), password.toCharArray());
        Certificate[] certificates = ImportKey.importCertificates(certificateFile);
        if (privateKeyFile != null) {
            PrivateKey privateKey = ImportKey.importPrivateKey(privateKeyFile);
            keyStore.setKeyEntry(alias, privateKey, password.toCharArray(), certificates);
        } else {
            keyStore.setCertificateEntry(alias, certificates[0]);
        }
        keyStore.store(new FileOutputStream(keystoreName), password.toCharArray());
    }

    private static PrivateKey importPrivateKey(String privateKeyFile) throws FileNotFoundException, IOException, NoSuchAlgorithmException, InvalidKeySpecException {
        FileInputStream keyStream = new FileInputStream(privateKeyFile);
        byte[] key = new byte[((InputStream)keyStream).available()];
        KeyFactory keyFacory = KeyFactory.getInstance("RSA");
        ((InputStream)keyStream).read(key, 0, ((InputStream)keyStream).available());
        ((InputStream)keyStream).close();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key);
        PrivateKey privateKey = keyFacory.generatePrivate(keySpec);
        return privateKey;
    }

    private static Certificate[] importCertificates(String certificateFile) throws CertificateException, FileNotFoundException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        FileInputStream certStream = new FileInputStream(certificateFile);
        Collection<? extends Certificate> certificates = certificateFactory.generateCertificates(certStream);
        Certificate[] certificateArray = certificates.toArray(new Certificate[certificates.size()]);
        return certificateArray;
    }
}

