/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.certificate;

import at.mrdevelopment.esl.core.ESLProperties;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.PKCS10CertificationRequest;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.x509.X509V3CertificateGenerator;

public class ESLKeyStore {
    private static final int KEYLENGTH = 2048;
    private KeyStore keyStore;
    private final String hostname;
    private static final String internalAliasCertificate = "imagotag";
    private static final String internalAliasKeys = "imagotag";

    public ESLKeyStore() throws InitializationException {
        this(ESLKeyStore.getHostName());
    }

    public ESLKeyStore(String hostname) throws InitializationException {
        try {
            ESLProperties.setKeyStore();
            this.hostname = hostname;
            this.loadOrCreateStore(System.getProperty("javax.net.ssl.keyStore"));
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public void importCertificate(X509Certificate certificate) throws KeyStoreException {
        this.keyStore.setCertificateEntry("imagotag", certificate);
    }

    public void importTrustedCertificate(KeyStore.TrustedCertificateEntry certificate) throws KeyStoreException {
        this.keyStore.setEntry("imagotag", certificate, new KeyStore.PasswordProtection(System.getProperty("javax.net.ssl.keyStorePassword").toCharArray()));
    }

    public Certificate getCertificate() throws KeyStoreException, InvalidKeyException, NoSuchAlgorithmException, SecurityException, SignatureException {
        if (!this.keyStore.containsAlias("imagotag")) {
            this.generateAndStoreKeyPair();
        }
        return this.keyStore.getCertificate("imagotag");
    }

    public PKCS10CertificationRequest getCertificationRequest() throws InvalidKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, KeyStoreException, UnrecoverableKeyException {
        KeyPair keyPair = this.getKeyPair();
        X500Principal subjectName = new X500Principal("CN=" + this.hostname);
        PKCS10CertificationRequest certificationRequest = new PKCS10CertificationRequest("MD5withRSA", subjectName, keyPair.getPublic(), null, keyPair.getPrivate());
        return certificationRequest;
    }

    private KeyPair getKeyPair() throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException, InvalidKeyException, SecurityException, SignatureException {
        Key key;
        if (!this.keyStore.containsAlias("imagotag")) {
            this.generateAndStoreKeyPair();
        }
        if ((key = this.keyStore.getKey("imagotag", System.getProperty("javax.net.ssl.keyStorePassword").toCharArray())) != null && key instanceof PrivateKey) {
            Certificate cert = this.keyStore.getCertificate("imagotag");
            PublicKey publicKey = cert.getPublicKey();
            return new KeyPair(publicKey, (PrivateKey)key);
        }
        return null;
    }

    private void generateAndStoreKeyPair() throws NoSuchAlgorithmException, KeyStoreException, InvalidKeyException, SecurityException, SignatureException {
        KeyPairGenerator keyGenenrator = KeyPairGenerator.getInstance("RSA");
        keyGenenrator.initialize(2048);
        KeyPair keyPair = keyGenenrator.genKeyPair();
        this.keyStore.setKeyEntry("imagotag", keyPair.getPrivate(), System.getProperty("javax.net.ssl.keyStorePassword").toCharArray(), new Certificate[]{this.createSelfSignedCertificate(keyPair)});
        this.save();
    }

    private void save() {
        try {
            FileOutputStream output = new FileOutputStream(new File(System.getProperty("javax.net.ssl.keyStore")));
            this.keyStore.store(output, System.getProperty("javax.net.ssl.keyStorePassword").toCharArray());
            output.close();
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    private Certificate createSelfSignedCertificate(KeyPair keyPair) throws InvalidKeyException, SecurityException, SignatureException {
        X509V3CertificateGenerator v3CertGen = new X509V3CertificateGenerator();
        v3CertGen.setSerialNumber(BigInteger.valueOf(System.currentTimeMillis()));
        v3CertGen.setIssuerDN((X509Name)new X509Principal("CN=" + this.hostname + ", OU=None, O=None L=None, C=None"));
        v3CertGen.setNotBefore(new Date(System.currentTimeMillis() - 2592000000L));
        v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 315360000000L));
        v3CertGen.setSubjectDN((X509Name)new X509Principal("CN=" + this.hostname + ", OU=None, O=None L=None, C=None"));
        v3CertGen.setPublicKey(keyPair.getPublic());
        v3CertGen.setSignatureAlgorithm("MD5WithRSAEncryption");
        X509Certificate certificate = v3CertGen.generateX509Certificate(keyPair.getPrivate());
        return certificate;
    }

    private void loadOrCreateStore(String storeFile) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, InvalidKeyException, SecurityException, SignatureException {
        File file = new File(storeFile);
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        FileInputStream inputStream = file.exists() ? new FileInputStream(file) : null;
        this.keyStore.load(inputStream, System.getProperty("javax.net.ssl.keyStorePassword").toCharArray());
        if (inputStream != null) {
            inputStream.close();
        } else {
            this.getCertificate();
            this.save();
            System.out.println("Store created at: " + System.getProperty("javax.net.ssl.keyStore"));
        }
    }

    public String getPrivateKeyPEM() throws UnrecoverableKeyException, InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SecurityException, SignatureException, IOException {
        return this.writePEM(this.getKeyPair().getPrivate());
    }

    public String getPublicKeyPEM() throws UnrecoverableKeyException, InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, SecurityException, SignatureException, IOException {
        return this.writePEM(this.getKeyPair().getPublic());
    }

    public String getCertificatePEM() throws KeyStoreException, IOException, InvalidKeyException, NoSuchAlgorithmException, SecurityException, SignatureException {
        return this.writePEM(this.getCertificate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writePEM(Object object) throws IOException {
        String string;
        PEMWriter writer = null;
        try {
            StringWriter stringWriter = new StringWriter();
            writer = new PEMWriter((Writer)stringWriter);
            writer.writeObject(object);
            string = stringWriter.toString();
        }
        catch (Throwable throwable) {
            StreamUtils.close(writer);
            throw throwable;
        }
        StreamUtils.close((Writer)writer);
        return string;
    }

    public void setKeyPairFromPEM(String publicKey, String privateKey) throws IOException, InvalidKeyException, KeyStoreException, SecurityException, SignatureException {
        publicKey = this.cleanKey(publicKey);
        privateKey = this.cleanKey(privateKey);
        Object pkey = this.readPEM(privateKey);
        KeyPair keyPair = null;
        if (pkey instanceof KeyPair) {
            keyPair = (KeyPair)pkey;
        } else if (pkey instanceof PrivateKey) {
            keyPair = new KeyPair((PublicKey)this.readPEM(publicKey), (PrivateKey)pkey);
        } else {
            throw new IllegalArgumentException();
        }
        this.keyStore.setKeyEntry("imagotag", keyPair.getPrivate(), System.getProperty("javax.net.ssl.keyStorePassword").toCharArray(), new Certificate[]{this.createSelfSignedCertificate(keyPair)});
        this.save();
    }

    private String cleanKey(String pemKey) {
        if (pemKey.contains("\n")) {
            return pemKey;
        }
        pemKey = pemKey.replace("-----BEGIN PUBLIC KEY-----", "-----BEGIN PUBLIC KEY-----\n");
        pemKey = pemKey.replace("-----BEGIN RSA PRIVATE KEY-----", "-----BEGIN RSA PRIVATE KEY-----\n");
        pemKey = pemKey.replace("-----END", "\n-----END");
        return pemKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object readPEM(String data) throws IOException {
        Object object;
        PEMReader reader = null;
        try {
            reader = new PEMReader((Reader)new StringReader(data));
            object = reader.readObject();
        }
        catch (Throwable throwable) {
            StreamUtils.close(reader);
            throw throwable;
        }
        StreamUtils.close((Reader)reader);
        return object;
    }

    public String getCertificationRequestPEM() throws InvalidKeyException, UnrecoverableKeyException, NoSuchAlgorithmException, NoSuchProviderException, SignatureException, KeyStoreException, IOException {
        return this.writePEM(this.getCertificationRequest());
    }

    public String getFingerprint() throws Exception {
        MessageDigest md = MessageDigest.getInstance("MD5");
        md.update(this.getKeyPair().getPublic().getEncoded());
        return new String(Hex.encodeHex((byte[])md.digest()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importCertificate(File file) throws IOException, KeyStoreException, InvalidKeyException, SecurityException, SignatureException, UnrecoverableKeyException, NoSuchAlgorithmException {
        if (file.getName().contains(".pem")) {
            PEMReader reader = null;
            try {
                Certificate[] certificateArray;
                reader = new PEMReader((Reader)new FileReader(file));
                ArrayList<Certificate> certificates = new ArrayList<Certificate>();
                KeyPair keyPair = null;
                while (reader.ready()) {
                    Object obj = reader.readObject();
                    if (obj instanceof Certificate) {
                        certificates.add((Certificate)obj);
                        continue;
                    }
                    if (!(obj instanceof KeyPair)) continue;
                    keyPair = (KeyPair)obj;
                }
                if (certificates.isEmpty()) {
                    Certificate[] certificateArray2 = new Certificate[1];
                    certificateArray = certificateArray2;
                    certificateArray2[0] = this.createSelfSignedCertificate(keyPair);
                } else {
                    certificateArray = certificates.toArray(new Certificate[certificates.size()]);
                }
                Certificate[] chain = certificateArray;
                keyPair = keyPair == null ? this.getKeyPair() : keyPair;
                this.keyStore.setKeyEntry("imagotag", keyPair.getPrivate(), System.getProperty("javax.net.ssl.keyStorePassword").toCharArray(), chain);
                this.save();
            }
            catch (Throwable throwable) {
                StreamUtils.close(reader);
                throw throwable;
            }
            StreamUtils.close((Reader)reader);
        }
    }

    private static String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException exc) {
            return "localhost";
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

