/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform;

import at.mrdevelopment.esl.admin.platform.AccessPointStorage;
import at.mrdevelopment.esl.admin.platform.BackendTaskInfo;
import at.mrdevelopment.esl.admin.platform.BackendTaskStatus;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.joda.time.DateTime;

public class HSQLDBAccessPointStorage
implements AccessPointStorage {
    static ESLLogger logger = ESLLogger.getLogger(HSQLDBAccessPointStorage.class);
    private static final String JDBC_DRIVER_CLASS = "org.hsqldb.jdbc.JDBCDriver";
    private static final String CONNECTION_STRING = "jdbc:hsqldb:hsql://localhost/storage";
    private static final String USER = "SA";
    private static final String PASSWORD = "";
    private static final String TABLE_TASKS = "tasks";
    private static final String TABLE_CONFIGURATION = "configuration";
    private static final String COLUMN_ID = "id";
    private static final String COLUMN_TASK_NAME = "task_name";
    private static final String COLUMN_ARGUMENTS = "arguments";
    private static final String COLUMN_CREATE_TIME = "create_time";
    private static final String COLUMN_START_TIME = "start_time";
    private static final String COLUMN_END_TIME = "end_time";
    private static final String COLUMN_STATUS = "status";
    private static final String COLUMN_KEY = "key";
    private static final String COLUMN_VALUE = "value";
    private static final String COLUMN_UPDATE_TIME = "update_time";
    private static final String CREATE_TASKS_TABLE = String.format("CREATE TABLE IF NOT EXISTS %s (%s INTEGER GENERATED ALWAYS AS IDENTITY, %s VARCHAR(255) NOT NULL, %s VARCHAR(255), %s TIMESTAMP NOT NULL, %s TIMESTAMP, %s TIMESTAMP, %s INTEGER, PRIMARY KEY (%s))", "tasks", "id", "task_name", "arguments", "create_time", "start_time", "end_time", "status", "id");
    private static final String CREATE_CONFIGURATION_TABLE = String.format("CREATE TABLE IF NOT EXISTS %s (%s VARCHAR(255) NOT NULL UNIQUE, %s VARCHAR(255), %s TIMESTAMP NOT NULL)", "configuration", "key", "value", "update_time");
    private static final String QUERY_CONNECTION_TEST = String.format("SELECT 1 FROM %s", "tasks");
    private static final String QUERY_NEXT_NEW_TASK = String.format("SELECT * FROM %s WHERE %s IS NULL ORDER BY %s LIMIT 1", "tasks", "start_time", "id");
    private static final String UPDATE_START_TIME = String.format("UPDATE %s SET %s = ? WHERE %s = ?", "tasks", "start_time", "id");
    private static final String UPDATE_END_TIME_AND_STATUS = String.format("UPDATE %s SET %s = ?, %s = ? WHERE %s = ?", "tasks", "end_time", "status", "id");
    private static final String INSERT_TASK = String.format("INSERT INTO %s (%s, %s, %s) VALUES (?, ?, ?)", "tasks", "task_name", "arguments", "create_time");
    private static final String QUERY_TASKS = String.format("SELECT * FROM %s ORDER BY %s", "tasks", "id");
    private static final String QUERY_TASK_BY_ID = String.format("SELECT * FROM %s WHERE %s = ?", "tasks", "id");
    private static final String QUERY_CONFIGURATION = String.format("SELECT * FROM %s ORDER BY %s", "configuration", "key");
    private static final String QUERY_CONFIGURATION_KEY = String.format("SELECT * FROM %s WHERE %s = ?", "configuration", "key");
    private static final String INSERT_CONFIGURATION = String.format("INSERT INTO %s (%s, %s, %s) VALUES (?, ?, ?)", "configuration", "key", "value", "update_time");
    private static final String UPDATE_CONFIGURATION = String.format("UPDATE %s SET %s = ?, %s = ? WHERE %s = ?", "configuration", "value", "update_time", "key");
    private Connection connection;
    private PreparedStatement queryConnectionTest;
    private PreparedStatement queryNextNewTask;
    private PreparedStatement updateStartTime;
    private PreparedStatement updateEndTimeAndStatus;
    private PreparedStatement insertTask;
    private PreparedStatement queryTasks;
    private PreparedStatement queryTaskById;
    private PreparedStatement queryConfiguration;
    private PreparedStatement queryConfigurationKey;
    private PreparedStatement insertConfiguration;
    private PreparedStatement updateConfiguration;

    public HSQLDBAccessPointStorage() throws InitializationException, SerializeException {
        try {
            Class.forName(JDBC_DRIVER_CLASS);
        }
        catch (ClassNotFoundException exc) {
            throw new InitializationException((Throwable)exc);
        }
        this.connection = this.connect();
    }

    private Connection connect() throws SerializeException {
        Connection connection;
        try {
            connection = DriverManager.getConnection(CONNECTION_STRING, USER, PASSWORD);
        }
        catch (SQLException exc) {
            throw new SerializeException("Could not connect to database", new Object[0]);
        }
        try {
            this.createTables(connection);
            this.prepareStatements(connection);
        }
        catch (SQLException exc) {
            throw new SerializeException((Throwable)exc);
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTables(Connection connection) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            statement.executeUpdate(CREATE_TASKS_TABLE);
            statement.executeUpdate(CREATE_CONFIGURATION_TABLE);
        }
        finally {
            this.closeStatement(statement);
        }
    }

    private void prepareStatements(Connection connection) throws SQLException {
        this.queryConnectionTest = connection.prepareStatement(QUERY_CONNECTION_TEST);
        this.queryNextNewTask = connection.prepareStatement(QUERY_NEXT_NEW_TASK);
        this.updateStartTime = connection.prepareStatement(UPDATE_START_TIME);
        this.updateEndTimeAndStatus = connection.prepareStatement(UPDATE_END_TIME_AND_STATUS);
        this.insertTask = connection.prepareStatement(INSERT_TASK, 1);
        this.queryTasks = connection.prepareStatement(QUERY_TASKS);
        this.queryTaskById = connection.prepareStatement(QUERY_TASK_BY_ID);
        this.queryConfiguration = connection.prepareStatement(QUERY_CONFIGURATION);
        this.queryConfigurationKey = connection.prepareStatement(QUERY_CONFIGURATION_KEY);
        this.insertConfiguration = connection.prepareStatement(INSERT_CONFIGURATION);
        this.updateConfiguration = connection.prepareStatement(UPDATE_CONFIGURATION);
    }

    private void reopenConnection() throws SerializeException {
        if (!this.isConnectionAlive()) {
            this.shutdown();
            this.connection = this.connect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnectionAlive() {
        ResultSet resultSet = null;
        try {
            resultSet = this.queryConnectionTest.executeQuery();
            boolean bl = true;
            return bl;
        }
        catch (SQLException exc) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeResultSet(resultSet);
        }
    }

    @Override
    public long insertTask(BackendTaskInfo taskInfo) throws SerializeException {
        this.reopenConnection();
        return this.writeTask(taskInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BackendTaskInfo queryNextTask() throws SerializeException {
        BackendTaskInfo taskInfo;
        block8: {
            this.reopenConnection();
            taskInfo = null;
            ResultSet resultSet = null;
            try {
                resultSet = this.queryNextNewTask.executeQuery();
                if (!resultSet.next()) break block8;
                taskInfo = this.readTask(resultSet);
                try {
                    this.updateStartTime.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
                    this.updateStartTime.setLong(2, taskInfo.getId());
                    this.updateStartTime.executeUpdate();
                }
                finally {
                    this.clearParameters(this.updateStartTime);
                }
            }
            catch (SQLException exc) {
                throw new SerializeException((Throwable)exc);
            }
            finally {
                this.closeResultSet(resultSet);
            }
        }
        return taskInfo;
    }

    @Override
    public void closeTask(long id, BackendTaskStatus status) throws SerializeException {
        this.reopenConnection();
        try {
            this.updateEndTimeAndStatus.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            this.updateEndTimeAndStatus.setInt(2, status.getCode());
            this.updateEndTimeAndStatus.setLong(3, id);
            this.updateEndTimeAndStatus.executeUpdate();
        }
        catch (SQLException exc) {
            throw new SerializeException((Throwable)exc);
        }
        finally {
            this.clearParameters(this.updateEndTimeAndStatus);
        }
    }

    @Override
    public List<BackendTaskInfo> queryTasks() throws SerializeException {
        this.reopenConnection();
        ArrayList<BackendTaskInfo> taskInfos = new ArrayList<BackendTaskInfo>();
        ResultSet resultSet = null;
        try {
            resultSet = this.queryTasks.executeQuery();
            while (resultSet.next()) {
                BackendTaskInfo taskInfo = this.readTask(resultSet);
                taskInfos.add(taskInfo);
            }
        }
        catch (SQLException exc) {
            throw new SerializeException((Throwable)exc);
        }
        finally {
            this.closeResultSet(resultSet);
        }
        return taskInfos;
    }

    @Override
    public BackendTaskInfo queryTask(long id) throws SerializeException {
        this.reopenConnection();
        BackendTaskInfo taskInfo = null;
        ResultSet resultSet = null;
        try {
            this.queryTaskById.setLong(1, id);
            resultSet = this.queryTaskById.executeQuery();
            if (resultSet.next()) {
                BackendTaskInfo backendTaskInfo = this.readTask(resultSet);
                return backendTaskInfo;
            }
        }
        catch (SQLException exc) {
            throw new SerializeException((Throwable)exc);
        }
        finally {
            this.clearParameters(this.queryTaskById);
            this.closeResultSet(resultSet);
        }
        return taskInfo;
    }

    @Override
    public Map<String, String> queryConfiguration() throws SerializeException {
        this.reopenConnection();
        TreeMap<String, String> configuration = new TreeMap<String, String>();
        ResultSet resultSet = null;
        try {
            resultSet = this.queryConfiguration.executeQuery();
            while (resultSet.next()) {
                String key = resultSet.getString(COLUMN_KEY);
                String value = resultSet.getString(COLUMN_VALUE);
                configuration.put(key, value);
            }
        }
        catch (SQLException exc) {
            throw new SerializeException((Throwable)exc);
        }
        finally {
            this.closeResultSet(resultSet);
        }
        return configuration;
    }

    @Override
    public String queryKey(String key) throws SerializeException {
        this.reopenConnection();
        String value = null;
        ResultSet resultSet = null;
        try {
            this.queryConfigurationKey.setString(1, key);
            resultSet = this.queryConfigurationKey.executeQuery();
            if (resultSet.next()) {
                String string = resultSet.getString(COLUMN_VALUE);
                return string;
            }
        }
        catch (SQLException exc) {
            throw new SerializeException((Throwable)exc);
        }
        finally {
            this.clearParameters(this.queryConfigurationKey);
            this.closeResultSet(resultSet);
        }
        return value;
    }

    @Override
    public void storeKey(String key, String value) throws SerializeException {
        this.reopenConnection();
        if (this.keyExists(key)) {
            this.updateKey(key, value);
        } else {
            this.insertKey(key, value);
        }
    }

    public void shutdown() {
        this.closeStatement(this.queryConnectionTest);
        this.closeStatement(this.queryNextNewTask);
        this.closeStatement(this.updateStartTime);
        this.closeStatement(this.updateEndTimeAndStatus);
        this.closeStatement(this.insertTask);
        this.closeStatement(this.queryTasks);
        this.closeStatement(this.queryTaskById);
        this.closeStatement(this.queryConfiguration);
        this.closeStatement(this.queryConfigurationKey);
        this.closeStatement(this.insertConfiguration);
        this.closeStatement(this.updateConfiguration);
        this.closeConnection(this.connection);
    }

    private BackendTaskInfo readTask(ResultSet resultSet) throws SQLException {
        long id = resultSet.getLong(COLUMN_ID);
        String taskName = resultSet.getString(COLUMN_TASK_NAME);
        String taskArguments = resultSet.getString(COLUMN_ARGUMENTS);
        DateTime createTime = this.toDateTime(resultSet.getTimestamp(COLUMN_CREATE_TIME));
        DateTime startTime = this.toDateTime(resultSet.getTimestamp(COLUMN_START_TIME));
        DateTime endTime = this.toDateTime(resultSet.getTimestamp(COLUMN_END_TIME));
        BackendTaskStatus status = this.toStatus(resultSet.getInt(COLUMN_STATUS));
        return new BackendTaskInfo(id, taskName, taskArguments, createTime, startTime, endTime, status);
    }

    private DateTime toDateTime(Timestamp time) {
        return time != null ? new DateTime(time.getTime()) : null;
    }

    private BackendTaskStatus toStatus(int status) {
        return BackendTaskStatus.valueOf(status);
    }

    private long writeTask(BackendTaskInfo taskInfo) throws SerializeException {
        try {
            this.insertTask.setString(1, taskInfo.getTaskName());
            this.insertTask.setString(2, taskInfo.getTaskArguments());
            this.insertTask.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            this.insertTask.executeUpdate();
        }
        catch (SQLException exc) {
            throw new SerializeException((Throwable)exc);
        }
        finally {
            this.clearParameters(this.insertTask);
        }
        ResultSet resultSet = null;
        try {
            resultSet = this.insertTask.getGeneratedKeys();
            if (resultSet.next()) {
                long l = resultSet.getLong(COLUMN_ID);
                return l;
            }
        }
        catch (SQLException exc) {
            throw new SerializeException((Throwable)exc);
        }
        finally {
            this.closeResultSet(resultSet);
        }
        throw new SerializeException("Task insert returns without generated ID", new Object[0]);
    }

    private boolean keyExists(String key) throws SerializeException {
        ResultSet resultSet = null;
        try {
            this.queryConfigurationKey.setString(1, key);
            resultSet = this.queryConfigurationKey.executeQuery();
            boolean bl = resultSet.next();
            return bl;
        }
        catch (SQLException exc) {
            throw new SerializeException((Throwable)exc);
        }
        finally {
            this.clearParameters(this.queryConfigurationKey);
            this.closeResultSet(resultSet);
        }
    }

    private void insertKey(String key, String value) throws SerializeException {
        try {
            this.insertConfiguration.setString(1, key);
            this.insertConfiguration.setString(2, value);
            this.insertConfiguration.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            this.insertConfiguration.executeUpdate();
        }
        catch (SQLException exc) {
            throw new SerializeException((Throwable)exc);
        }
        finally {
            this.clearParameters(this.insertConfiguration);
        }
    }

    private void updateKey(String key, String value) throws SerializeException {
        try {
            this.updateConfiguration.setString(1, value);
            this.updateConfiguration.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            this.updateConfiguration.setString(3, key);
            this.updateConfiguration.executeUpdate();
        }
        catch (SQLException exc) {
            throw new SerializeException((Throwable)exc);
        }
        finally {
            this.clearParameters(this.updateConfiguration);
        }
    }

    private void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void clearParameters(PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.clearParameters();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void closeConnection(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

