/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.NetworkAddressUtils;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.log4j.MDC;

public class EnvironmentProperties {
    private final long deviceUUID;
    private final String hardwareAddress;
    private final String address;
    private final String subnetMask;
    private final String broadcast;
    private final String adapterName;
    private final String operatingSystem;
    private final String hostName;

    public EnvironmentProperties(boolean parseHostname) throws InitializationException {
        try {
            NetworkEnvironment network = this.parseNetworkEnvironment();
            this.deviceUUID = network.deviceUUID;
            this.hardwareAddress = network.hardwareAddress;
            this.address = network.address;
            this.subnetMask = network.subnetMask;
            this.broadcast = network.broadcast;
            this.adapterName = network.adapterName;
            this.operatingSystem = this.parseOperatingSystem();
            this.hostName = parseHostname ? this.parseHostname() : "localhost";
            this.addMDCLoggingInformation();
        }
        catch (Exception exc) {
            throw new InitializationException((Throwable)exc);
        }
    }

    private NetworkEnvironment parseNetworkEnvironment() throws UnknownHostException, SocketException {
        Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
        while (interfaces.hasMoreElements()) {
            NetworkInterface networkInterface = interfaces.nextElement();
            if (networkInterface.isLoopback()) continue;
            for (InterfaceAddress interfaceAddress : networkInterface.getInterfaceAddresses()) {
                byte[] hardwareAddress = networkInterface.getHardwareAddress();
                InetAddress address = interfaceAddress.getAddress();
                InetAddress subnetMask = NetworkAddressUtils.networkPrefixToSubnetMask((int)interfaceAddress.getNetworkPrefixLength());
                if (interfaceAddress == null || hardwareAddress == null || !(address instanceof Inet4Address)) continue;
                NetworkEnvironment network = new NetworkEnvironment();
                network.address = address.getHostAddress();
                network.subnetMask = subnetMask.getHostAddress();
                network.broadcast = NetworkAddressUtils.calculateBroadcastAddress((Inet4Address)((Inet4Address)address), (int)interfaceAddress.getNetworkPrefixLength()).getHostAddress();
                network.adapterName = networkInterface.getDisplayName();
                network.hardwareAddress = NetworkAddressUtils.hardwareAddressToString((byte[])hardwareAddress);
                network.deviceUUID = this.generateUUID(hardwareAddress);
                return network;
            }
        }
        throw new RuntimeException("Could not load network information");
    }

    private String parseOperatingSystem() {
        String osProperty = System.getProperty("os.name").toLowerCase();
        if (osProperty.indexOf("windows") > -1) {
            return "WINDOWS";
        }
        if (osProperty.indexOf("linux") > -1) {
            return "LINUX";
        }
        if (osProperty.indexOf("mac") > -1) {
            return "MAC";
        }
        return "OTHER";
    }

    private String parseHostname() {
        try {
            InetAddress address = InetAddress.getLocalHost();
            return address.getCanonicalHostName();
        }
        catch (UnknownHostException ignore) {
            return "localhost";
        }
    }

    private long generateUUID(byte[] hardwareAddress) {
        long deviceUUID = 0L;
        for (byte addressByte : hardwareAddress) {
            deviceUUID = (long)(addressByte & 0xFF) | deviceUUID << 8;
        }
        return deviceUUID;
    }

    public String getMacAddress() {
        return this.hardwareAddress;
    }

    public String getIPAddress() {
        return this.address;
    }

    public String getSubnetMask() {
        return this.subnetMask;
    }

    public String getBroadcast() {
        return this.broadcast;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getUUID() {
        return Long.toString(this.deviceUUID);
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public static void main(String[] args) throws Exception {
        EnvironmentProperties environmentProperties = new EnvironmentProperties(true);
        System.out.println(environmentProperties.getOperatingSystem());
        System.out.println(environmentProperties.getAdapterName());
        System.out.println(environmentProperties.getUUID());
        System.out.println(environmentProperties.getMacAddress());
        System.out.println(environmentProperties.getIPAddress());
        System.out.println(environmentProperties.getSubnetMask());
        System.out.println(environmentProperties.getBroadcast());
        System.out.println(environmentProperties.getHostName());
    }

    private void addMDCLoggingInformation() {
        MDC.put((String)"ADDRESS", (Object)(this.address != null ? this.address : "localhost"));
    }

    private static class NetworkEnvironment {
        long deviceUUID;
        String hardwareAddress;
        String address;
        String subnetMask;
        String broadcast;
        String adapterName;

        private NetworkEnvironment() {
        }
    }
}

