/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform;

import at.mrdevelopment.esl.admin.platform.AccessPointStorage;
import at.mrdevelopment.esl.admin.platform.SystemAttributes;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.security.Password;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class DefaultSystemAttributes
implements SystemAttributes {
    private static final String SYSTEM_ID = "system.id";
    private static final String SYSTEM_REVISION = "system.revision";
    private static final String SYSTEM_SERIAL = "system.serial";
    private static final String SYSTEM_PASSWORD = "system.password";
    private static final String SYSTEM_DEFAULT_PASSWORD = "system.default.password";
    private final AccessPointStorage storage;
    private int accessPointId;
    private int revision;
    private String serial;
    private Password password;
    private Password defaultPassword;

    public DefaultSystemAttributes(AccessPointStorage storage, boolean failOnMissingAccessPointId) throws SerializeException, InitializationException {
        this.storage = storage;
        this.loadAccessPointId(failOnMissingAccessPointId);
        this.loadRevision();
        this.loadSerial();
        this.loadPassword();
        this.loadDefaultPassword();
    }

    @Override
    public synchronized int getAccessPointId() {
        return this.accessPointId;
    }

    @Override
    public synchronized int getRevision() {
        return this.revision;
    }

    @Override
    public synchronized String getSerial() {
        return this.serial;
    }

    @Override
    public synchronized Password getPassword() {
        return this.password;
    }

    @Override
    public synchronized Password getDefaultPassword() {
        return this.defaultPassword;
    }

    public synchronized void setDefaultPassword(Password password) throws Exception {
        if (password == null) {
            throw new IllegalArgumentException();
        }
        this.save(SYSTEM_DEFAULT_PASSWORD, password.getSaltedHash());
        this.defaultPassword = password;
    }

    @Override
    public synchronized void setPassword(Password password) throws Exception {
        if (password == null) {
            throw new IllegalArgumentException();
        }
        this.save(SYSTEM_PASSWORD, password.getSaltedHash());
        this.password = password;
    }

    public synchronized void setAccessPointId(int accessPointId) throws SerializeException {
        if (accessPointId < 0) {
            throw new IllegalArgumentException();
        }
        this.save(SYSTEM_ID, accessPointId);
        this.accessPointId = accessPointId;
    }

    public synchronized void setRevision(int revision) throws SerializeException {
        if (revision < 0) {
            throw new IllegalArgumentException();
        }
        this.save(SYSTEM_REVISION, revision);
        this.revision = revision;
    }

    public synchronized void setSerial(String serial) throws SerializeException {
        if (serial == null) {
            throw new IllegalArgumentException();
        }
        this.save(SYSTEM_SERIAL, serial);
        this.serial = serial;
    }

    private void loadAccessPointId(boolean failOnMissingAccessPointId) throws SerializeException, InitializationException {
        Integer accessPointId = this.load(SYSTEM_ID, Integer.class);
        if (accessPointId == null && failOnMissingAccessPointId) {
            throw new InitializationException("No access point ID specified", new Object[0]);
        }
        this.accessPointId = accessPointId != null ? accessPointId : 0;
    }

    private void loadRevision() throws SerializeException {
        Integer revision = this.load(SYSTEM_REVISION, Integer.class);
        this.revision = revision != null ? revision : 0;
    }

    private void loadSerial() throws SerializeException {
        String serial = this.load(SYSTEM_SERIAL, String.class);
        this.serial = serial != null ? serial : "";
    }

    private void loadPassword() throws SerializeException, InitializationException {
        Password password = this.load(SYSTEM_PASSWORD, Password.class);
        if (password == null) {
            try {
                password = Password.createFromPlainPassword((String)"admin");
            }
            catch (Exception exc) {
                throw new InitializationException((Throwable)exc, "Could not create default password", new Object[0]);
            }
        }
        this.password = password;
    }

    @Override
    public void loadDefaultPassword() throws SerializeException, InitializationException {
        Password password = this.load(SYSTEM_DEFAULT_PASSWORD, Password.class);
        if (password == null) {
            try {
                password = Password.createFromPlainPassword((String)"admin");
            }
            catch (Exception exc) {
                throw new InitializationException((Throwable)exc, "Could not create default password", new Object[0]);
            }
        }
        this.defaultPassword = password;
    }

    private void save(String key, Object value) throws SerializeException {
        this.storage.storeKey(key, value != null ? value.toString() : null);
    }

    private <T> T load(String key, Class<T> type) throws SerializeException {
        String value = this.storage.queryKey(key);
        if (value == null) {
            return null;
        }
        try {
            if (type == String.class) {
                return type.cast(value);
            }
            if (type == Integer.class) {
                return type.cast(Integer.parseInt(value));
            }
            if (type == Password.class) {
                return type.cast(new Password(value));
            }
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc, "Failed to parse storage key %s", new Object[]{key});
        }
        throw new SerializeException("Unsupported storage type %s for key %s", new Object[]{type.getName(), key});
    }
}

