/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform;

import at.mrdevelopment.esl.admin.AccessPointConfiguration;
import at.mrdevelopment.esl.admin.AutoConfiguration;
import at.mrdevelopment.esl.admin.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.LogLevel;
import at.mrdevelopment.esl.admin.LoggingConfiguration;
import at.mrdevelopment.esl.admin.NetworkConfiguration;
import at.mrdevelopment.esl.admin.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.AccessPointStorage;
import at.mrdevelopment.esl.admin.platform.ConfigurationStorage;
import at.mrdevelopment.esl.core.WirelessChannel;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;

public class DefaultConfigurationStorage
implements ConfigurationStorage {
    static ESLLogger logger = ESLLogger.getLogger(DefaultConfigurationStorage.class);
    private static final String CONFIG_INITIALIZED = "config.initialized";
    private static final String AUTOCONFIG_ENABLED = "autoconfig.enabled";
    private static final String WIRELESS_CHANNEL = "wireless.channel";
    private static final String NETWORK_HOSTNAME = "network.hostname";
    private static final String NETWORK_DHCP = "network.dhcp";
    private static final String NETWORK_ADDRESS = "network.address";
    private static final String NETWORK_NETMASK = "network.netmask";
    private static final String NETWORK_GATEWAY = "network.gateway";
    private static final String NETWORK_NAMESERVER1 = "network.nameserver1";
    private static final String NETWORK_NAMESERVER2 = "network.nameserver2";
    private static final String TIMESYNC_ENABLED = "timesync.enabled";
    private static final String TIMESYNC_TIMESERVER = "timesync.timeserver";
    private static final String TIMESYNC_INTERVAL = "timesync.interval";
    private static final String MSP_ENABLED = "msp.enabled";
    private static final String MSP_HOST = "msp.host";
    private static final String MSP_PORT = "msp.port";
    private static final String MSP_USERNAME = "msp.username";
    private static final String MSP_PASSWORD = "msp.password";
    private static final String MSP_PATH = "msp.path";
    private static final String MSP_INTERVAL = "msp.interval";
    private static final String BROADCAST_ENABLED = "broadcast.enabled";
    private static final String BROADCAST_INTERVAL = "broadcast.interval";
    private static final String BROADCAST_PORT = "broadcast.port";
    private static final String LOGGING_LEVEL = "logging.level";
    private static final String LOGGING_ENABLED = "logging.enabled";
    private static final String LOGGING_HOST = "logging.host";
    private static final String LOGGING_PORT = "logging.port";
    private final AccessPointStorage storage;

    public DefaultConfigurationStorage(AccessPointStorage storage) throws SerializeException {
        this.storage = storage;
    }

    @Override
    public void initialize(AccessPointConfiguration initialConfiguration) throws SerializeException {
        if (!this.isInitialized()) {
            this.saveConfiguration(initialConfiguration);
        }
    }

    @Override
    public void saveConfiguration(AccessPointConfiguration newConfiguration) throws SerializeException {
        this.saveAutoConfiguration(newConfiguration.getAutoConfiguration());
        this.saveWirelessConfiguration(newConfiguration.getWirelessConfiguration());
        this.saveNetworkConfiguration(newConfiguration.getNetworkConfiguration());
        this.saveTimesyncConfiguration(newConfiguration.getTimesyncConfiguration());
        this.saveMSPConfiguration(newConfiguration.getMSPConfiguration());
        this.saveBroadcastConfiguration(newConfiguration.getBroadcastConfiguration());
        this.saveLoggingConfiguration(newConfiguration.getLoggingConfiguration());
        this.save(CONFIG_INITIALIZED, true);
    }

    private void saveAutoConfiguration(AutoConfiguration autoConfiguration) throws SerializeException {
        this.save(AUTOCONFIG_ENABLED, autoConfiguration.isEnabled());
    }

    private void saveWirelessConfiguration(WirelessConfiguration wirelessConfiguration) throws SerializeException {
        this.save(WIRELESS_CHANNEL, (Object)wirelessConfiguration.getChannel());
    }

    private void saveNetworkConfiguration(NetworkConfiguration networkConfiguration) throws SerializeException {
        this.save(NETWORK_HOSTNAME, networkConfiguration.getHostName());
        this.save(NETWORK_DHCP, networkConfiguration.isDhcp());
        this.save(NETWORK_ADDRESS, networkConfiguration.getAddress());
        this.save(NETWORK_NETMASK, networkConfiguration.getNetmask());
        this.save(NETWORK_GATEWAY, networkConfiguration.getGateway());
        this.save(NETWORK_NAMESERVER1, networkConfiguration.getNameServer1());
        this.save(NETWORK_NAMESERVER2, networkConfiguration.getNameServer2());
    }

    private void saveTimesyncConfiguration(TimesyncConfiguration timesyncConfiguration) throws SerializeException {
        this.save(TIMESYNC_ENABLED, timesyncConfiguration.isEnabled());
        this.save(TIMESYNC_TIMESERVER, timesyncConfiguration.getTimeServer());
        this.save(TIMESYNC_INTERVAL, timesyncConfiguration.getUpdateInterval());
    }

    private void saveMSPConfiguration(MSPConfiguration mspConfiguration) throws SerializeException {
        this.save(MSP_ENABLED, mspConfiguration.isEnabled());
        this.save(MSP_HOST, mspConfiguration.getHost());
        this.save(MSP_PORT, mspConfiguration.getPort());
        this.save(MSP_USERNAME, mspConfiguration.getUsername());
        this.save(MSP_PASSWORD, mspConfiguration.getPassword());
        this.save(MSP_PATH, mspConfiguration.getPath());
        this.save(MSP_INTERVAL, mspConfiguration.getUploadInterval());
    }

    private void saveBroadcastConfiguration(BroadcastConfiguration broadcastConfiguration) throws SerializeException {
        this.save(BROADCAST_ENABLED, broadcastConfiguration.isBroadcastEnabled());
        this.save(BROADCAST_INTERVAL, broadcastConfiguration.getTimeIntervalInMinutes());
        this.save(BROADCAST_PORT, broadcastConfiguration.getBroadcastPort());
    }

    private void saveLoggingConfiguration(LoggingConfiguration loggingConfiguration) throws SerializeException {
        this.save(LOGGING_LEVEL, (Object)loggingConfiguration.getLogLevel());
        this.save(LOGGING_ENABLED, loggingConfiguration.isSocketAppenderEnabled());
        this.save(LOGGING_HOST, loggingConfiguration.getSocketRemoteAddress());
        this.save(LOGGING_PORT, loggingConfiguration.getSocketAppenderPort());
    }

    @Override
    public AccessPointConfiguration loadConfiguration() throws SerializeException {
        this.waitForInitialization();
        AutoConfiguration autoConfiguration = this.loadAutoConfiguration();
        WirelessConfiguration wirelessConfiguration = this.loadWirelessConfiguration();
        NetworkConfiguration networkConfiguration = this.loadNetworkConfiguration();
        TimesyncConfiguration timesyncConfiguration = this.loadTimesyncConfiguration();
        MSPConfiguration mspConfiguration = this.loadMSPConfiguration();
        BroadcastConfiguration broadcastConfiguration = this.loadBroadcastConfiguration();
        LoggingConfiguration loggingConfiguration = this.loadLoggingConfiguration();
        return new AccessPointConfiguration(autoConfiguration, wirelessConfiguration, networkConfiguration, timesyncConfiguration, mspConfiguration, broadcastConfiguration, loggingConfiguration);
    }

    private void waitForInitialization() throws SerializeException {
        while (!this.isInitialized()) {
            logger.info("Waiting for configuration...");
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException exc) {
                throw new SerializeException("Configuration not initialized", new Object[0]);
            }
        }
    }

    private boolean isInitialized() throws SerializeException {
        Boolean initialized = this.load(CONFIG_INITIALIZED, Boolean.class);
        return initialized != null && initialized != false;
    }

    private AutoConfiguration loadAutoConfiguration() throws SerializeException {
        boolean enabled = this.load(AUTOCONFIG_ENABLED, Boolean.class);
        return new AutoConfiguration(enabled);
    }

    private WirelessConfiguration loadWirelessConfiguration() throws SerializeException {
        WirelessChannel channel = this.load(WIRELESS_CHANNEL, WirelessChannel.class);
        return new WirelessConfiguration(channel);
    }

    private NetworkConfiguration loadNetworkConfiguration() throws SerializeException {
        String hostName = this.load(NETWORK_HOSTNAME, String.class);
        boolean dhcp = this.load(NETWORK_DHCP, Boolean.class);
        if (dhcp) {
            return new NetworkConfiguration(hostName);
        }
        String address = this.load(NETWORK_ADDRESS, String.class);
        String netmask = this.load(NETWORK_NETMASK, String.class);
        String gateway = this.load(NETWORK_GATEWAY, String.class);
        String nameServer1 = this.load(NETWORK_NAMESERVER1, String.class);
        String nameServer2 = this.load(NETWORK_NAMESERVER2, String.class);
        return new NetworkConfiguration(hostName, address, netmask, gateway, nameServer1, nameServer2);
    }

    private TimesyncConfiguration loadTimesyncConfiguration() throws SerializeException {
        boolean enabled = this.load(TIMESYNC_ENABLED, Boolean.class);
        String timeServer = this.load(TIMESYNC_TIMESERVER, String.class);
        int updateIntervalInMinutes = this.load(TIMESYNC_INTERVAL, Integer.class);
        return new TimesyncConfiguration(enabled, timeServer, updateIntervalInMinutes);
    }

    private MSPConfiguration loadMSPConfiguration() throws SerializeException {
        boolean enabled = this.load(MSP_ENABLED, Boolean.class);
        String host = this.load(MSP_HOST, String.class);
        int port = this.load(MSP_PORT, Integer.class);
        String username = this.load(MSP_USERNAME, String.class);
        String password = this.load(MSP_PASSWORD, String.class);
        String path = this.load(MSP_PATH, String.class);
        int uploadIntervalInMinutes = this.load(MSP_INTERVAL, Integer.class);
        return new MSPConfiguration(host, port, username, password, path, uploadIntervalInMinutes, enabled);
    }

    private BroadcastConfiguration loadBroadcastConfiguration() throws SerializeException {
        boolean enabled = this.load(BROADCAST_ENABLED, Boolean.class);
        int intervalInMinutes = this.load(BROADCAST_INTERVAL, Integer.class);
        int port = this.load(BROADCAST_PORT, Integer.class);
        return new BroadcastConfiguration(enabled, intervalInMinutes, port);
    }

    private LoggingConfiguration loadLoggingConfiguration() throws SerializeException {
        LogLevel logLevel = this.load(LOGGING_LEVEL, LogLevel.class);
        boolean enabled = this.load(LOGGING_ENABLED, Boolean.class);
        String host = this.load(LOGGING_HOST, String.class);
        int port = this.load(LOGGING_PORT, Integer.class);
        return new LoggingConfiguration(logLevel, port, host, enabled);
    }

    private void save(String key, Object value) throws SerializeException {
        this.storage.storeKey(key, value != null ? value.toString() : null);
    }

    private <T> T load(String key, Class<T> type) throws SerializeException {
        String value = this.storage.queryKey(key);
        if (value == null) {
            return null;
        }
        try {
            if (type == String.class) {
                return type.cast(value);
            }
            if (type == Boolean.class) {
                return type.cast(Boolean.valueOf(value));
            }
            if (type == Integer.class) {
                return type.cast(Integer.parseInt(value));
            }
            if (type == LogLevel.class) {
                return type.cast((Object)LogLevel.valueOf(value));
            }
            if (type == WirelessChannel.class) {
                if (value.isEmpty()) {
                    return null;
                }
                return type.cast((Object)WirelessChannel.getFromLogicalChannel(Integer.parseInt(value)));
            }
        }
        catch (Exception exc) {
            throw new SerializeException((Throwable)exc, "Failed to parse storage key %s", new Object[]{key});
        }
        throw new SerializeException("Unsupported storage type %s for key %s", new Object[]{type.getName(), key});
    }
}

