/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform;

import at.mrdevelopment.esl.admin.AutoConfiguration;
import at.mrdevelopment.esl.admin.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.DateTimeConfiguration;
import at.mrdevelopment.esl.admin.LoggingConfiguration;
import at.mrdevelopment.esl.admin.NetworkConfiguration;
import at.mrdevelopment.esl.admin.TimeZoneConfiguration;
import at.mrdevelopment.esl.admin.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.AccessPointStorage;
import at.mrdevelopment.esl.admin.platform.BackendControl;
import at.mrdevelopment.esl.admin.platform.BackendTaskInfo;
import at.mrdevelopment.esl.admin.platform.BackendTaskStatus;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class DefaultBackendControl
implements BackendControl {
    static ESLLogger logger = ESLLogger.getLogger(DefaultBackendControl.class);
    private static final int TASK_TIMEOUT_IN_SECONDS = 15;
    private final AccessPointStorage storage;
    private final boolean asynchronous;

    public DefaultBackendControl(AccessPointStorage accessPointStorage, boolean asynchronous) throws InitializationException {
        this.storage = accessPointStorage;
        this.asynchronous = asynchronous;
    }

    @Override
    public BackendTaskStatus applyConfigurationChanges(Map<Class<?>, String> configurationChanges) throws SerializeException {
        ArrayList<BackendTaskInfo> tasks = new ArrayList<BackendTaskInfo>(configurationChanges.size());
        for (Class<?> configurationChange : configurationChanges.keySet()) {
            if (configurationChange == AutoConfiguration.class) {
                tasks.add(new BackendTaskInfo("AutoConfigTask"));
                continue;
            }
            if (configurationChange == WirelessConfiguration.class) {
                tasks.add(new BackendTaskInfo("WirelessTask"));
                continue;
            }
            if (configurationChange == NetworkConfiguration.class) {
                tasks.add(new BackendTaskInfo("NetworkTask"));
                continue;
            }
            if (configurationChange == TimesyncConfiguration.class) {
                tasks.add(new BackendTaskInfo("TimesyncTask"));
                continue;
            }
            if (configurationChange == MSPConfiguration.class) {
                tasks.add(new BackendTaskInfo("MSPTask"));
                continue;
            }
            if (configurationChange == BroadcastConfiguration.class) {
                tasks.add(new BackendTaskInfo("BroadcastTask"));
                continue;
            }
            if (configurationChange == LoggingConfiguration.class) {
                tasks.add(new BackendTaskInfo("LoggingTask"));
                continue;
            }
            if (configurationChange == DateTimeConfiguration.class) {
                tasks.add(new BackendTaskInfo("DateTimeTask", configurationChanges.get(configurationChange)));
                continue;
            }
            if (configurationChange != TimeZoneConfiguration.class) continue;
            tasks.add(new BackendTaskInfo("TimeZoneTask", configurationChanges.get(configurationChange)));
        }
        return this.addBackendTasks(tasks);
    }

    @Override
    public BackendTaskStatus initSystemShutdown() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("SystemShutdownTask"));
    }

    @Override
    public BackendTaskStatus initSystemReboot() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("SystemRebootTask"));
    }

    @Override
    public BackendTaskStatus initServiceRestart() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("ServiceRestartTask"));
    }

    @Override
    public BackendTaskStatus initServiceShutdown() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("ServiceShutdownTask"));
    }

    @Override
    public BackendTaskStatus initRestoreToFactoryDefaults() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("FactoryResetTask"));
    }

    @Override
    public BackendTaskStatus initRestoreToFactoryDefaultsAndReboot() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("FactoryResetAndRebootTask"));
    }

    @Override
    public BackendTaskStatus initSoftwareUpdate(String updatePackageFilename) throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("SoftwareUpdateTask", updatePackageFilename));
    }

    @Override
    public BackendTaskStatus initFirmwareUpdate(String firmwareFilename) throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("FirmwareUpdateTask", firmwareFilename));
    }

    @Override
    public BackendTaskStatus initImageInitialization() throws SerializeException {
        return this.addBackendTask(new BackendTaskInfo("ImageInitializationTask"));
    }

    private BackendTaskStatus addBackendTask(BackendTaskInfo taskInfo) throws SerializeException {
        if (this.asynchronous) {
            return this.scheduleBackendTask(taskInfo);
        }
        return this.executeBackendTask(taskInfo);
    }

    private BackendTaskStatus addBackendTasks(List<BackendTaskInfo> tasks) throws SerializeException {
        if (this.asynchronous) {
            for (BackendTaskInfo taskInfo : tasks) {
                this.scheduleBackendTask(taskInfo);
            }
            return BackendTaskStatus.SCHEDULED;
        }
        BackendTaskStatus returnStatus = BackendTaskStatus.SUCCESSFUL;
        for (BackendTaskInfo taskInfo : tasks) {
            BackendTaskStatus taskStatus = this.executeBackendTask(taskInfo);
            if (taskStatus == BackendTaskStatus.SUCCESSFUL) continue;
            returnStatus = taskStatus;
        }
        return returnStatus;
    }

    private BackendTaskStatus scheduleBackendTask(BackendTaskInfo taskInfo) throws SerializeException {
        this.storage.insertTask(taskInfo);
        return BackendTaskStatus.SCHEDULED;
    }

    private BackendTaskStatus executeBackendTask(BackendTaskInfo taskInfo) throws SerializeException {
        BackendTaskInfo taskResult;
        long id = this.storage.insertTask(taskInfo);
        DateTime timeout = DateTime.now().plusSeconds(15);
        do {
            if (!timeout.isBeforeNow()) continue;
            return BackendTaskStatus.TIMEOUT;
        } while (!(taskResult = this.storage.queryTask(id)).isFinished());
        return taskResult.getStatus();
    }

    @Override
    public List<BackendTaskInfo> getTasks() throws SerializeException {
        return this.storage.queryTasks();
    }

    @Override
    public Map<String, String> getConfiguration() throws SerializeException {
        return this.storage.queryConfiguration();
    }
}

