/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin.platform;

import at.mrdevelopment.esl.admin.AccessPointConfiguration;
import at.mrdevelopment.esl.admin.AutoConfiguration;
import at.mrdevelopment.esl.admin.BroadcastConfiguration;
import at.mrdevelopment.esl.admin.ConfigurationChangeManager;
import at.mrdevelopment.esl.admin.DateTimeConfiguration;
import at.mrdevelopment.esl.admin.LoggingConfiguration;
import at.mrdevelopment.esl.admin.NetworkConfiguration;
import at.mrdevelopment.esl.admin.TimeZoneConfiguration;
import at.mrdevelopment.esl.admin.TimesyncConfiguration;
import at.mrdevelopment.esl.admin.WirelessConfiguration;
import at.mrdevelopment.esl.admin.platform.BackendControl;
import at.mrdevelopment.esl.admin.platform.ConfigurationStorage;
import at.mrdevelopment.esl.msp.MSPConfiguration;
import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.xml.SerializeException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.map.HashedMap;

public class ConfigurationManager {
    static ESLLogger logger = ESLLogger.getLogger(ConfigurationManager.class);
    private final BackendControl backendControl;
    private final ConfigurationStorage configurationStorage;
    private final ConfigurationChangeManager configurationChangeManager;
    private AccessPointConfiguration accessPointConfiguration;
    private TimeZoneConfiguration timeZoneConfiguration;

    public ConfigurationManager(BackendControl backendControl, ConfigurationStorage configurationStorage) throws InitializationException, SerializeException {
        this.backendControl = backendControl;
        this.configurationStorage = configurationStorage;
        this.configurationChangeManager = new ConfigurationChangeManager();
        this.timeZoneConfiguration = new TimeZoneConfiguration();
        this.reload();
    }

    public synchronized void reload() throws SerializeException {
        this.accessPointConfiguration = this.configurationStorage.loadConfiguration();
        this.accessPointConfiguration.getLoggingConfiguration().apply();
        this.timeZoneConfiguration = new TimeZoneConfiguration();
    }

    public synchronized AccessPointConfiguration getAccessPointConfiguration() {
        return this.accessPointConfiguration;
    }

    public synchronized AutoConfiguration getAutoConfiguration() {
        return this.accessPointConfiguration.getAutoConfiguration();
    }

    public synchronized TimeZoneConfiguration getTimeZoneConfiguration() {
        return this.timeZoneConfiguration;
    }

    public synchronized DateTimeConfiguration getDateTimeConfiguration() {
        return new DateTimeConfiguration();
    }

    public synchronized boolean setAutoConfiguration(AutoConfiguration autoConfiguration) throws SerializeException {
        AccessPointConfiguration newConfiguration = new AccessPointConfiguration(autoConfiguration, this.accessPointConfiguration.getWirelessConfiguration(), this.accessPointConfiguration.getNetworkConfiguration(), this.accessPointConfiguration.getTimesyncConfiguration(), this.accessPointConfiguration.getMSPConfiguration(), this.accessPointConfiguration.getBroadcastConfiguration(), this.accessPointConfiguration.getLoggingConfiguration());
        return this.updateConfiguration(newConfiguration);
    }

    public synchronized WirelessConfiguration getWirelessConfiguration() {
        return this.accessPointConfiguration.getWirelessConfiguration();
    }

    public synchronized boolean setWirelessConfiguration(WirelessConfiguration wirelessConfiguration) throws SerializeException {
        AccessPointConfiguration newConfiguration = new AccessPointConfiguration(AutoConfiguration.DISABLED, wirelessConfiguration, this.accessPointConfiguration.getNetworkConfiguration(), this.accessPointConfiguration.getTimesyncConfiguration(), this.accessPointConfiguration.getMSPConfiguration(), this.accessPointConfiguration.getBroadcastConfiguration(), this.accessPointConfiguration.getLoggingConfiguration());
        return this.updateConfiguration(newConfiguration);
    }

    public synchronized NetworkConfiguration getNetworkConfiguration() {
        return this.accessPointConfiguration.getNetworkConfiguration();
    }

    public synchronized boolean setNetworkConfiguration(NetworkConfiguration networkConfiguration) throws SerializeException {
        AccessPointConfiguration newConfiguration = new AccessPointConfiguration(AutoConfiguration.DISABLED, this.accessPointConfiguration.getWirelessConfiguration(), networkConfiguration, this.accessPointConfiguration.getTimesyncConfiguration(), this.accessPointConfiguration.getMSPConfiguration(), this.accessPointConfiguration.getBroadcastConfiguration(), this.accessPointConfiguration.getLoggingConfiguration());
        return this.updateConfiguration(newConfiguration);
    }

    public synchronized TimesyncConfiguration getTimesyncConfiguration() {
        return this.accessPointConfiguration.getTimesyncConfiguration();
    }

    public synchronized boolean setTimesyncConfiguration(TimesyncConfiguration timesyncConfiguration) throws SerializeException {
        AccessPointConfiguration newConfiguration = new AccessPointConfiguration(AutoConfiguration.DISABLED, this.accessPointConfiguration.getWirelessConfiguration(), this.accessPointConfiguration.getNetworkConfiguration(), timesyncConfiguration, this.accessPointConfiguration.getMSPConfiguration(), this.accessPointConfiguration.getBroadcastConfiguration(), this.accessPointConfiguration.getLoggingConfiguration());
        return this.updateConfiguration(newConfiguration);
    }

    public synchronized MSPConfiguration getMspConfiguration() {
        return this.accessPointConfiguration.getMSPConfiguration();
    }

    public synchronized boolean setMspConfiguration(MSPConfiguration mspConfiguration) throws SerializeException {
        AccessPointConfiguration newConfiguration = new AccessPointConfiguration(AutoConfiguration.DISABLED, this.accessPointConfiguration.getWirelessConfiguration(), this.accessPointConfiguration.getNetworkConfiguration(), this.accessPointConfiguration.getTimesyncConfiguration(), mspConfiguration, this.accessPointConfiguration.getBroadcastConfiguration(), this.accessPointConfiguration.getLoggingConfiguration());
        return this.updateConfiguration(newConfiguration);
    }

    public synchronized BroadcastConfiguration getBroadcastConfiguration() {
        return this.accessPointConfiguration.getBroadcastConfiguration();
    }

    public synchronized boolean setBroadcastConfiguration(BroadcastConfiguration broadcastConfiguration) throws SerializeException {
        AccessPointConfiguration newConfiguration = new AccessPointConfiguration(AutoConfiguration.DISABLED, this.accessPointConfiguration.getWirelessConfiguration(), this.accessPointConfiguration.getNetworkConfiguration(), this.accessPointConfiguration.getTimesyncConfiguration(), this.accessPointConfiguration.getMSPConfiguration(), broadcastConfiguration, this.accessPointConfiguration.getLoggingConfiguration());
        return this.updateConfiguration(newConfiguration);
    }

    public synchronized LoggingConfiguration getLoggingConfiguration() {
        return this.accessPointConfiguration.getLoggingConfiguration();
    }

    public synchronized boolean setLoggingConfiguration(LoggingConfiguration loggingConfiguration) throws SerializeException {
        AccessPointConfiguration newConfiguration = new AccessPointConfiguration(AutoConfiguration.DISABLED, this.accessPointConfiguration.getWirelessConfiguration(), this.accessPointConfiguration.getNetworkConfiguration(), this.accessPointConfiguration.getTimesyncConfiguration(), this.accessPointConfiguration.getMSPConfiguration(), this.accessPointConfiguration.getBroadcastConfiguration(), loggingConfiguration);
        return this.updateConfiguration(newConfiguration);
    }

    public synchronized boolean setAccessPointConfiguration(AccessPointConfiguration incomingConfiguration) throws SerializeException {
        AccessPointConfiguration newConfiguration = new AccessPointConfiguration(this.accessPointConfiguration.getAutoConfiguration(), incomingConfiguration.getWirelessConfiguration(), incomingConfiguration.getNetworkConfiguration(), incomingConfiguration.getTimesyncConfiguration(), incomingConfiguration.getMSPConfiguration(), incomingConfiguration.getBroadcastConfiguration(), incomingConfiguration.getLoggingConfiguration());
        return this.updateConfiguration(newConfiguration);
    }

    public synchronized boolean setTimeConfiguration(DateTimeConfiguration newDateTimeConfiguration, TimeZoneConfiguration newTimeZoneConfiguration, TimesyncConfiguration newTimesyncConfiguration) throws SerializeException {
        HashMap configurationChanges = new HashMap();
        if (newTimeZoneConfiguration.hasChanged()) {
            configurationChanges.put(TimeZoneConfiguration.class, newTimeZoneConfiguration.getTaskArgument());
        }
        if (newDateTimeConfiguration.hasConfiguration() && newDateTimeConfiguration.hasChanged()) {
            configurationChanges.put(DateTimeConfiguration.class, newDateTimeConfiguration.getTaskArgumentString());
        }
        if (this.configurationChangeManager.hasChanged(this.accessPointConfiguration.getTimesyncConfiguration(), newTimesyncConfiguration)) {
            configurationChanges.put(TimesyncConfiguration.class, null);
            AccessPointConfiguration newConfiguration = new AccessPointConfiguration(AutoConfiguration.DISABLED, this.accessPointConfiguration.getWirelessConfiguration(), this.accessPointConfiguration.getNetworkConfiguration(), newTimesyncConfiguration, this.accessPointConfiguration.getMSPConfiguration(), this.accessPointConfiguration.getBroadcastConfiguration(), this.accessPointConfiguration.getLoggingConfiguration());
            this.configurationStorage.saveConfiguration(newConfiguration);
            this.accessPointConfiguration = newConfiguration;
        }
        if (configurationChanges.size() > 0) {
            this.backendControl.applyConfigurationChanges(configurationChanges);
            return true;
        }
        return false;
    }

    public synchronized boolean setTimeZoneConfiguration(TimeZoneConfiguration newTimeZoneConfiguration) throws SerializeException {
        if (newTimeZoneConfiguration.hasChanged()) {
            HashMap configurationChanges = new HashMap();
            configurationChanges.put(TimeZoneConfiguration.class, newTimeZoneConfiguration.getTaskArgument());
            this.backendControl.applyConfigurationChanges(configurationChanges);
            return true;
        }
        return false;
    }

    public synchronized boolean setDateTimeConfiguration(DateTimeConfiguration newDateTimeConfiguration) throws SerializeException {
        if (newDateTimeConfiguration.hasConfiguration() && newDateTimeConfiguration.hasChanged()) {
            HashedMap configurationChanges = new HashedMap();
            configurationChanges.put(DateTimeConfiguration.class, newDateTimeConfiguration.getTaskArgumentString());
            this.backendControl.applyConfigurationChanges((Map<Class<?>, String>)configurationChanges);
            return true;
        }
        return false;
    }

    private boolean updateConfiguration(AccessPointConfiguration newConfiguration) throws SerializeException {
        HashMap configurationChanges = new HashMap();
        if (this.configurationChangeManager.hasChanged(this.accessPointConfiguration.getAutoConfiguration(), newConfiguration.getAutoConfiguration())) {
            configurationChanges.put(AutoConfiguration.class, null);
        }
        if (this.configurationChangeManager.hasChanged(this.accessPointConfiguration.getWirelessConfiguration(), newConfiguration.getWirelessConfiguration())) {
            configurationChanges.put(WirelessConfiguration.class, null);
        }
        if (this.configurationChangeManager.hasChanged(this.accessPointConfiguration.getNetworkConfiguration(), newConfiguration.getNetworkConfiguration())) {
            configurationChanges.put(NetworkConfiguration.class, null);
        }
        if (this.configurationChangeManager.hasChanged(this.accessPointConfiguration.getTimesyncConfiguration(), newConfiguration.getTimesyncConfiguration())) {
            configurationChanges.put(TimesyncConfiguration.class, null);
        }
        if (this.configurationChangeManager.hasChanged(this.accessPointConfiguration.getMSPConfiguration(), newConfiguration.getMSPConfiguration())) {
            configurationChanges.put(MSPConfiguration.class, null);
        }
        if (this.configurationChangeManager.hasChanged(this.accessPointConfiguration.getBroadcastConfiguration(), newConfiguration.getBroadcastConfiguration())) {
            configurationChanges.put(BroadcastConfiguration.class, null);
        }
        if (this.configurationChangeManager.hasChanged(this.accessPointConfiguration.getLoggingConfiguration(), newConfiguration.getLoggingConfiguration())) {
            configurationChanges.put(LoggingConfiguration.class, null);
            newConfiguration.getLoggingConfiguration().apply();
        }
        if (configurationChanges.size() > 0) {
            this.configurationStorage.saveConfiguration(newConfiguration);
            this.backendControl.applyConfigurationChanges(configurationChanges);
            this.accessPointConfiguration = newConfiguration;
            return true;
        }
        return false;
    }
}

