/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;

public class TimeZoneConfiguration {
    private final TimeZone timeZone;

    public TimeZoneConfiguration() {
        this(TimeZoneConfiguration.getCurrentTimeZone());
    }

    public TimeZoneConfiguration(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public String getTimeZoneString() {
        return TimeZoneConfiguration.toTimeZoneString(this.timeZone);
    }

    public String getTaskArgument() {
        return this.timeZone.getID();
    }

    public boolean hasChanged() {
        return !this.timeZone.equals(TimeZoneConfiguration.getCurrentTimeZone());
    }

    public static TimeZone getCurrentTimeZone() {
        return Calendar.getInstance().getTimeZone();
    }

    public static String toTimeZoneString(TimeZone timeZone) {
        return String.format("(UTC%s) %s", TimeZoneConfiguration.toOffsetString(timeZone), timeZone.getID());
    }

    public static String toOffsetString(TimeZone timeZone) {
        int offset = timeZone.getRawOffset();
        int offsetHours = (int)Math.floor(offset / 1000 / 60 / 60);
        int offsetMinutes = Math.abs(offset / 1000 / 60 % 60);
        DecimalFormat format = new DecimalFormat("+00;-00");
        return String.format("%s:%02d", format.format(offsetHours), offsetMinutes);
    }

    public static TimeZone fromString(String timeZoneString) {
        String[] splitted = StringUtils.split((String)timeZoneString, (String)" ");
        if (splitted.length < 2) {
            throw new IllegalArgumentException(String.format("Illegal time zone format: %s", timeZoneString));
        }
        StringBuilder builder = new StringBuilder();
        for (int index = 1; index < splitted.length; ++index) {
            builder.append(splitted[index]);
            if (index == splitted.length - 1) continue;
            builder.append(" ");
        }
        return TimeZone.getTimeZone(builder.toString());
    }
}

