/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.esl.admin;

import at.mrdevelopment.toolkit.log.ESLLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;

public class NetworkConfiguration {
    static ESLLogger logger = ESLLogger.getLogger(NetworkConfiguration.class);
    private static final String DEFAULT_HOSTNAME = "imagotag-ap";
    private final String hostName;
    private final boolean dhcp;
    private final String address;
    private final String netmask;
    private final String gateway;
    private final String nameServer1;
    private final String nameServer2;

    public NetworkConfiguration(String hostName, String address, String netmask, String gateway, String nameServer1, String nameServer2) {
        this.hostName = hostName;
        this.dhcp = false;
        this.address = address;
        this.netmask = netmask;
        this.gateway = gateway;
        this.nameServer1 = nameServer1;
        this.nameServer2 = nameServer2;
    }

    public NetworkConfiguration(String hostName) {
        this.hostName = hostName;
        this.dhcp = true;
        this.address = null;
        this.netmask = null;
        this.gateway = null;
        this.nameServer1 = null;
        this.nameServer2 = null;
    }

    public NetworkConfiguration(String hostName, NetworkConfiguration networkConfiguration) {
        this.hostName = hostName;
        this.dhcp = networkConfiguration.dhcp;
        this.address = networkConfiguration.address;
        this.netmask = networkConfiguration.netmask;
        this.gateway = networkConfiguration.gateway;
        this.nameServer1 = networkConfiguration.nameServer1;
        this.nameServer2 = networkConfiguration.nameServer2;
    }

    public NetworkConfiguration() {
        this(DEFAULT_HOSTNAME);
    }

    public String getHostName() {
        return this.hostName;
    }

    public boolean isDhcp() {
        return this.dhcp;
    }

    public String getAddress() {
        return this.address;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getGateway() {
        return this.gateway;
    }

    public String getNameServer1() {
        return this.nameServer1;
    }

    public String getNameServer2() {
        return this.nameServer2;
    }

    public Collection<String> getNameServers() {
        ArrayList<String> nameServers = new ArrayList<String>(2);
        if (this.nameServer1 != null && !this.nameServer1.isEmpty()) {
            nameServers.add(this.nameServer1);
        }
        if (this.nameServer2 != null && !this.nameServer2.isEmpty()) {
            nameServers.add(this.nameServer2);
        }
        return nameServers;
    }

    public Properties toProperties() {
        Properties properties = new Properties();
        properties.setProperty("hostname", this.hostName);
        properties.setProperty("dhcp", Boolean.toString(this.dhcp));
        properties.setProperty("address", this.address != null ? this.address : "");
        properties.setProperty("netmask", this.netmask != null ? this.netmask : "");
        properties.setProperty("gateway", this.gateway != null ? this.gateway : "");
        properties.setProperty("nameserver1", this.nameServer1 != null ? this.nameServer1 : "");
        properties.setProperty("nameserver2", this.nameServer2 != null ? this.nameServer2 : "");
        return properties;
    }
}

